/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.base.BaseString;
import adams.core.io.SpreadSheet;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.Serializable;

public class SpreadSheetStatistic
extends AbstractTransformer {
    private static final long serialVersionUID = -540187402790189753L;
    protected DataType m_DataType;
    protected BaseString[] m_Locations;
    protected AbstractArrayStatistic m_Statistic;

    public String globalInfo() {
        return "Generates statistics from a SpreadSheet object.\nIf cells aren't numeric or missing, a default value of zero is used.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "dataType", (Object)DataType.COLUMN_BY_INDEX);
        this.m_OptionManager.add("location", "locations", (Object)new BaseString[0]);
        this.m_OptionManager.add("statistic", "statistic", (Object)new ArrayMean());
    }

    public void setDataType(DataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public DataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "Whether to retrieve rows or columns from the Instances object.";
    }

    public void setLocations(BaseString[] value) {
        this.m_Locations = value;
        this.reset();
    }

    public BaseString[] getLocations() {
        return this.m_Locations;
    }

    public String locationsTipText() {
        return "The locations of the data, depending on the chosen data type that can be either indices or regular expressions on the attribute names.";
    }

    public void setStatistic(AbstractArrayStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractArrayStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The statistic to generate from the data.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("statistic");
        if (variable != null) {
            return variable;
        }
        if (this.m_Statistic != null) {
            return this.m_Statistic.getClass().getName().replaceAll("adams\\.data\\.statistics\\.", "");
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected Double[] getRow(SpreadSheet sheet, int index) {
        SpreadSheet.Row row = sheet.getRow(index);
        Double[] result = new Double[sheet.getColumnCount()];
        for (int i = 0; i < result.length; ++i) {
            SpreadSheet.Cell cell = row.getCell(i);
            result[i] = cell == null || cell.isMissing() || !cell.isNumeric() ? new Double(0.0) : new Double(cell.getContent());
        }
        return result;
    }

    protected Double[] getColumn(SpreadSheet sheet, int index) {
        Double[] result = new Double[sheet.getRowCount()];
        for (int i = 0; i < result.length; ++i) {
            SpreadSheet.Row row = sheet.getRow(i);
            SpreadSheet.Cell cell = row.getCell(index);
            result[i] = cell == null || cell.isMissing() || !cell.isNumeric() ? new Double(0.0) : new Double(cell.getContent());
        }
        return result;
    }

    protected String doExecute() {
        SpreadSheet sheet;
        String result = null;
        try {
            sheet = null;
            SpreadSheet data = (SpreadSheet)this.m_InputToken.getPayload();
            AbstractArrayStatistic stat = this.m_Statistic.shallowCopy(true);
            block7: for (int i = 0; i < this.m_Locations.length; ++i) {
                switch (this.m_DataType) {
                    case ROW_BY_INDEX: {
                        Index index = new Index(this.m_Locations[i].stringValue());
                        index.setMax(data.getRowCount());
                        stat.add((Serializable[])this.getRow(data, index.getIntIndex()));
                        continue block7;
                    }
                    case COLUMN_BY_INDEX: {
                        Index index = new Index(this.m_Locations[i].stringValue());
                        index.setMax(data.getColumnCount());
                        stat.add((Serializable[])this.getColumn(data, index.getIntIndex()));
                        continue block7;
                    }
                    case COLUMN_BY_REGEXP: {
                        for (int n = 0; n < data.getColumnCount(); ++n) {
                            if (!data.getHeaderRow().getCell(n).getContent().matches(this.m_Locations[i].stringValue())) continue;
                            stat.add((Serializable[])this.getColumn(data, n));
                            continue block7;
                        }
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("Unhandlded data type: " + (Object)((Object)this.m_DataType));
                    }
                }
            }
            sheet = stat.calculate().toSpreadSheet();
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
            result = "Error generating the statistic: " + e;
            sheet = null;
        }
        if (sheet != null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }

    public static enum DataType {
        ROW_BY_INDEX,
        COLUMN_BY_INDEX,
        COLUMN_BY_REGEXP;

    }
}

