/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.setupgenerator.Point;
import weka.core.setupgenerator.SpaceDimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Space
implements Serializable {
    private static final long serialVersionUID = -481830810204401148L;
    protected SpaceDimension[] m_Dimensions;

    public Space(SpaceDimension[] dimensions) {
        this.m_Dimensions = (SpaceDimension[])dimensions.clone();
    }

    public int dimensions() {
        return this.m_Dimensions.length;
    }

    public SpaceDimension getDimension(int dimension) {
        return this.m_Dimensions[dimension];
    }

    public int getType(int dimension) {
        return this.getDimension(dimension).getType();
    }

    public Point<Object> getValues(Point<Integer> locations) {
        if (locations.dimensions() != this.dimensions()) {
            throw new IllegalArgumentException("Dimension mismatch: space=" + this.dimensions() + ", locations=" + locations.dimensions());
        }
        Object[] values = new Object[locations.dimensions()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getDimension(i).getValue(locations.getValue(i));
        }
        Point<Object> result = new Point<Object>(values);
        return result;
    }

    public Point<Integer> getLocations(Point<Object> values) {
        if (values.dimensions() != this.dimensions()) {
            throw new IllegalArgumentException("Dimension mismatch: space=" + this.dimensions() + ", values=" + values.dimensions());
        }
        Integer[] locations = new Integer[values.dimensions()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = this.getDimension(i).getLocation(values.getValue(i));
        }
        Point<Integer> result = new Point<Integer>(locations);
        return result;
    }

    public boolean isOnBorder(Point<?> points) {
        if (points.dimensions() != this.dimensions()) {
            throw new IllegalArgumentException("Dimension mismatch: space=" + this.dimensions() + ", points=" + points.dimensions());
        }
        Point<Object> locations = !(points.getValue(0) instanceof Integer) ? this.getLocations(points) : points;
        boolean result = false;
        for (int i = 0; i < this.dimensions(); ++i) {
            if (!this.getDimension(i).isOnBorder((Integer)locations.getValue(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    public Space subspace(Point<Integer> center) {
        SpaceDimension[] dimensions = new SpaceDimension[this.dimensions()];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = this.getDimension(i).subdimension(center.getValue(i) - 1, center.getValue(i) + 1);
        }
        Space result = new Space(dimensions);
        return result;
    }

    protected boolean inc(Integer[] locations, int[] max) {
        boolean result = true;
        int i = 0;
        while (i < locations.length) {
            if (locations[i] < max[i] - 1) {
                Integer[] integerArray = locations;
                int n = i;
                Integer n2 = integerArray[n];
                Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
                break;
            }
            locations[i] = 0;
            if (++i != locations.length) continue;
            result = false;
        }
        return result;
    }

    protected Vector<Point<Integer>> listPoints() {
        int i;
        Vector<Point<Integer>> result = new Vector<Point<Integer>>();
        int[] max = new int[this.dimensions()];
        for (i = 0; i < max.length; ++i) {
            max[i] = this.getDimension(i).width();
        }
        Integer[] locations = new Integer[this.dimensions()];
        for (i = 0; i < locations.length; ++i) {
            locations[i] = 0;
        }
        result.add(new Point<Integer>(locations));
        boolean ok = true;
        while (ok) {
            ok = this.inc(locations, max);
            if (!ok) continue;
            result.add(new Point<Integer>(locations));
        }
        return result;
    }

    public int size() {
        return this.listPoints().size();
    }

    public Enumeration<Point<Integer>> points() {
        return this.listPoints().elements();
    }

    public Enumeration<Point<Object>> values() {
        Vector<Point<Object>> result = new Vector<Point<Object>>();
        Vector<Point<Integer>> points = this.listPoints();
        for (int i = 0; i < points.size(); ++i) {
            result.add(this.getValues(points.get(i)));
        }
        return result.elements();
    }

    public String toString() {
        String result = this.dimensions() + "-dimensional space:";
        for (int i = 0; i < this.dimensions(); ++i) {
            result = result + "\n - " + (i + 1) + ". " + this.getDimension(i);
        }
        return result;
    }
}

