/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.data.random.AbstractSeededRandomNumberGenerator;
import adams.data.random.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChiSquare
extends AbstractSeededRandomNumberGenerator<Double> {
    private static final long serialVersionUID = -8789721700340129969L;
    protected int m_DegreesFreedom;
    protected Random m_Random;

    public String globalInfo() {
        return "Random generator that generates random doubles (0-1) using Java's java.util.Random class.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("df", "degreesFreedom", (Object)2);
    }

    public void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setDegreesFreedom(int value) {
        this.m_DegreesFreedom = value;
        this.reset();
    }

    public int getDegreesFreedom() {
        return this.m_DegreesFreedom;
    }

    public String degreesFreedomTipText() {
        return "The degrees of freedom to use.";
    }

    protected void check() {
        super.check();
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
    }

    protected Double doNext() {
        return this.m_Random.chi2(this.m_DegreesFreedom);
    }
}

