/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.CleanUpHandler;
import adams.core.ConsoleObject;
import adams.data.container.DataContainer;
import adams.data.statistics.InformativeStatistic;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStatistic<T extends DataContainer>
extends ConsoleObject
implements InformativeStatistic,
CleanUpHandler {
    private static final long serialVersionUID = 7783784686641582858L;
    protected Hashtable<String, Double> m_Statistics = new Hashtable();
    protected Vector<String> m_Names = new Vector();
    protected boolean m_Calculated = false;
    protected T m_Data = null;

    public AbstractDataStatistic() {
    }

    public AbstractDataStatistic(T data) {
        this();
        this.setData(data);
    }

    public abstract String globalInfo();

    @Override
    public void cleanUp() {
        this.clear();
    }

    protected void clear() {
        this.m_Calculated = false;
        this.m_Statistics.clear();
        this.m_Names.clear();
    }

    protected void calculate() {
        this.clear();
    }

    public void setData(T value) {
        this.m_Calculated = false;
        this.m_Data = value;
    }

    public T getData() {
        return this.m_Data;
    }

    public void add(String name, double value) {
        if (!this.m_Statistics.containsKey(name)) {
            this.m_Names.add(name);
        }
        this.m_Statistics.put(name, value);
    }

    protected double numberToDouble(Number value) {
        if (value == null) {
            return Double.NaN;
        }
        return value.doubleValue();
    }

    @Override
    public Enumeration<String> statisticNames() {
        if (!this.m_Calculated) {
            this.calculate();
        }
        return this.m_Names.elements();
    }

    @Override
    public double getStatistic(String name) {
        double result;
        if (!this.m_Calculated) {
            this.calculate();
        }
        if (this.m_Statistics.containsKey(name)) {
            result = this.m_Statistics.get(name);
        } else {
            this.getSystemErr().println("Statistic '" + name + "' is unknown!");
            result = Double.NaN;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Enumeration<String> names = this.statisticNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            result.append(name + ": " + this.getStatistic(name) + "\n");
        }
        return result.toString();
    }
}

