/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ClassLocator;
import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.NestedConsumer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractExternalActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorPath;
import adams.flow.core.ControlActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.InstantiatableActor;
import adams.flow.core.OutputProducer;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.FixDeprecatedCommandlineTransformers;
import adams.flow.processor.FlattenStructure;
import adams.flow.processor.MultiProcessor;
import adams.flow.processor.RemoveDisabledActors;
import adams.flow.processor.RemoveUnusedGlobalActors;
import adams.flow.sink.InstantiatableSink;
import adams.flow.source.InstantiatableSource;
import adams.flow.standalone.InstantiatableStandalone;
import adams.flow.transformer.GlobalTransformer;
import adams.flow.transformer.InstantiatableTransformer;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.core.GUIHelper;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorUtils {
    protected static void enumerate(AbstractActor actor, Vector<AbstractActor> children) {
        if (actor instanceof ActorHandler) {
            ActorHandler handler = (ActorHandler)((Object)actor);
            for (int i = 0; i < handler.size(); ++i) {
                children.add(handler.get(i));
                ActorUtils.enumerate(handler.get(i), children);
            }
        }
    }

    public static Vector<AbstractActor> enumerate(AbstractActor actor) {
        Vector<AbstractActor> result = new Vector<AbstractActor>();
        ActorUtils.enumerate(actor, result);
        return result;
    }

    public static int replace(OptionHandler handler, Comparable find, Comparable replace, boolean recursive) {
        return ActorUtils.replace(handler, find, replace, recursive, new HashSet<Class>());
    }

    public static int replace(OptionHandler handler, Comparable find, Comparable replace, boolean recursive, HashSet<Class> excluded) {
        int result = 0;
        List<AbstractOption> options = handler.getOptionManager().getOptionsList();
        for (int i = 0; i < options.size(); ++i) {
            int n;
            Object value;
            PropertyDescriptor desc;
            AbstractArgumentOption argoption;
            boolean updated = false;
            if (!(options.get(i) instanceof AbstractArgumentOption) || excluded.contains((argoption = (AbstractArgumentOption)options.get(i)).getBaseClass())) continue;
            if (!argoption.getBaseClass().equals(find.getClass())) {
                if (!recursive || !ClassLocator.hasInterface(OptionHandler.class, argoption.getBaseClass())) continue;
                desc = options.get(i).getDescriptor();
                try {
                    value = desc.getReadMethod().invoke((Object)handler, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    value = null;
                }
                if (value == null) continue;
                if (argoption.isMultiple()) {
                    for (n = 0; n < Array.getLength(value); ++n) {
                        result += ActorUtils.replace((OptionHandler)Array.get(value, n), find, replace, recursive);
                    }
                    continue;
                }
                result += ActorUtils.replace((OptionHandler)value, find, replace, recursive);
                continue;
            }
            desc = options.get(i).getDescriptor();
            try {
                value = desc.getReadMethod().invoke((Object)handler, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
            if (value == null) continue;
            if (argoption.isMultiple()) {
                for (n = 0; n < Array.getLength(value); ++n) {
                    if (!Array.get(value, n).equals(find)) continue;
                    Array.set(value, n, Utils.deepCopy(replace));
                    updated = true;
                    ++result;
                }
            } else if (value.equals(find)) {
                value = Utils.deepCopy(replace);
                updated = true;
                ++result;
            }
            if (!updated) continue;
            try {
                desc.getWriteMethod().invoke((Object)handler, value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean uniqueName(AbstractActor actor, ActorHandler handler, int index) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < handler.size(); ++i) {
            if (i == index) continue;
            names.add(handler.get(i).getName());
        }
        return ActorUtils.uniqueName(actor, names);
    }

    public static boolean uniqueName(AbstractActor actor, HashSet<String> names) {
        boolean result;
        String name;
        String baseName = actor.getName();
        int i = 0;
        do {
            name = i == 0 ? baseName : baseName + "-" + i;
            ++i;
        } while (names.contains(name));
        boolean bl = result = !name.equals(actor.getName());
        if (result) {
            actor.setName(name);
        }
        return result;
    }

    public static boolean uniqueNames(AbstractActor[] actors) {
        boolean result = false;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < actors.length; ++i) {
            if (i > 0) {
                result = ActorUtils.uniqueName(actors[i], names) || result;
            }
            names.add(actors[i].getName());
        }
        return result;
    }

    public static Vector<ActorHandler> findActorHandlers(AbstractActor actor) {
        return ActorUtils.findActorHandlers(actor, false);
    }

    public static Vector<ActorHandler> findActorHandlers(AbstractActor actor, boolean mustAllowStandalones) {
        return ActorUtils.findActorHandlers(actor, mustAllowStandalones, false);
    }

    public static Vector<ActorHandler> findActorHandlers(AbstractActor actor, boolean mustAllowStandalones, boolean includeSameLevel) {
        Vector<ActorHandler> result = new Vector<ActorHandler>();
        AbstractActor child = actor;
        for (AbstractActor parent = actor.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ActorHandler) {
                ActorHandler handler = (ActorHandler)((Object)parent);
                if (includeSameLevel) {
                    int index = handler.indexOf(child.getName());
                    for (int i = index - 1; i >= 0; --i) {
                        ActorHandler subhandler = null;
                        if (handler.get(i) instanceof AbstractExternalActor) {
                            AbstractExternalActor extActor = (AbstractExternalActor)handler.get(i);
                            if (extActor.getExternalActor() instanceof ActorHandler) {
                                subhandler = (ActorHandler)((Object)extActor.getExternalActor());
                            }
                        } else if (handler.get(i) instanceof ActorHandler) {
                            subhandler = (ActorHandler)((Object)handler.get(i));
                        }
                        if (subhandler == null) continue;
                        if (mustAllowStandalones) {
                            if (!subhandler.getActorHandlerInfo().canContainStandalones()) continue;
                            result.add(subhandler);
                            continue;
                        }
                        result.add(subhandler);
                    }
                }
                if (mustAllowStandalones) {
                    if (handler.getActorHandlerInfo().canContainStandalones()) {
                        result.add(handler);
                    }
                } else {
                    result.add(handler);
                }
            }
            child = parent;
        }
        return result;
    }

    public static boolean isStandalone(AbstractActor actor) {
        return !(actor instanceof InputConsumer) && !(actor instanceof OutputProducer);
    }

    public static boolean isSource(AbstractActor actor) {
        return !(actor instanceof InputConsumer) && actor instanceof OutputProducer;
    }

    public static boolean isSink(AbstractActor actor) {
        return actor instanceof InputConsumer && !(actor instanceof OutputProducer);
    }

    public static boolean isTransformer(AbstractActor actor) {
        return actor instanceof InputConsumer && actor instanceof OutputProducer;
    }

    public static boolean isControlActor(AbstractActor actor) {
        return actor instanceof ControlActor;
    }

    public static boolean isActorHandler(AbstractActor actor) {
        return actor instanceof ActorHandler;
    }

    public static boolean write(String filename, AbstractActor actor) {
        NestedProducer producer = new NestedProducer();
        producer.setOutputClasspath(true);
        producer.produce(actor);
        boolean result = producer.write(filename);
        return result;
    }

    public static AbstractActor read(String filename) {
        return ActorUtils.read(filename, null);
    }

    public static AbstractActor read(String filename, List<String> errors) {
        return ActorUtils.read(filename, errors, null);
    }

    public static AbstractActor read(String filename, List<String> errors, List<String> warnings) {
        NestedConsumer consumer = new NestedConsumer();
        AbstractActor result = (AbstractActor)consumer.read(filename);
        if (errors != null) {
            errors.addAll(consumer.getErrors());
        }
        if (warnings != null) {
            warnings.addAll(consumer.getWarnings());
        }
        return result;
    }

    public static Hashtable<String, Integer> findGlobalTransformers(AbstractActor actor) {
        Vector<AbstractActor> actors = ActorUtils.enumerate(actor);
        Hashtable<String, Integer> count = new Hashtable<String, Integer>();
        for (AbstractActor current : actors) {
            if (current.getSkip() || !(current instanceof GlobalTransformer)) continue;
            String name = ((GlobalTransformer)current).getGlobalName().toString();
            if (!count.containsKey(name)) {
                count.put(name, 1);
                continue;
            }
            count.put(name, count.get(name) + 1);
        }
        return count;
    }

    protected static AbstractActor findClosestType(ActorHandler handler, Class type) {
        AbstractActor result = null;
        for (int i = 0; i < handler.size(); ++i) {
            AbstractExternalActor external;
            if (handler.get(i).getClass().isAssignableFrom(type)) {
                result = handler.get(i);
                break;
            }
            if (handler.get(i) instanceof AbstractExternalActor && (external = (AbstractExternalActor)handler.get(i)).getExternalActor() instanceof ActorHandler && (result = ActorUtils.findClosestType((ActorHandler)((Object)external.getExternalActor()), type)) != null) break;
        }
        return result;
    }

    public static AbstractActor findClosestType(AbstractActor actor, Class type) {
        return ActorUtils.findClosestType(actor, type, false);
    }

    public static AbstractActor findClosestType(AbstractActor actor, Class type, boolean includeSameLevel) {
        AbstractActor result = null;
        Vector<ActorHandler> handlers = ActorUtils.findActorHandlers(actor, true, includeSameLevel);
        for (int i = 0; i < handlers.size() && (result = ActorUtils.findClosestType(handlers.get(i), type)) == null; ++i) {
        }
        return result;
    }

    public static Point determineLocation(JFrame frame, int x, int y) {
        int diffHeight;
        Point result = new Point();
        Dimension size = frame.getSize();
        if (size.getWidth() == 0.0 || size.getHeight() == 0.0) {
            size = frame.getPreferredSize();
        }
        Rectangle bounds = GUIHelper.getScreenBounds(frame);
        int actX = x == -1 ? 0 : (x == -2 ? (int)(((double)bounds.width - size.getWidth()) / 2.0) : (x == -3 ? (int)((double)bounds.width - size.getWidth()) : x));
        AbstractApplicationFrame main = Environment.getInstance().getApplicationFrame();
        int n = diffHeight = main != null ? main.getSize().height : 0;
        int actY = y == -1 ? diffHeight : (y == -2 ? (int)(((double)bounds.height - size.getHeight() - (double)diffHeight) / 2.0) : (y == -3 ? (int)((double)bounds.height - size.getHeight()) : y));
        result.setLocation(actX, actY);
        return result;
    }

    public static AbstractDatabaseConnection getDatabaseConnection(AbstractActor actor, Class cls, AbstractDatabaseConnection defCon) {
        adams.flow.standalone.AbstractDatabaseConnection conn = (adams.flow.standalone.AbstractDatabaseConnection)ActorUtils.findClosestType(actor, cls, true);
        AbstractDatabaseConnection result = conn != null ? conn.getConnection() : defCon;
        if (!result.isConnected()) {
            try {
                result.connect();
            }
            catch (Exception e) {
                System.err.println("Failed to enable database connection (" + cls.getName() + ") for actor " + actor.getFullName() + ":");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static AbstractActor removeDisabledActors(AbstractActor actor) {
        RemoveDisabledActors processor = new RemoveDisabledActors();
        processor.process(actor);
        AbstractActor result = processor.getModifiedActor();
        if (result == null) {
            result = actor;
        }
        return result;
    }

    public static AbstractActor createExternalActor(AbstractActor actor) {
        AbstractActor result = actor;
        if (!(actor instanceof InstantiatableActor)) {
            if (ActorUtils.isStandalone(actor)) {
                result = new InstantiatableStandalone();
                ((InstantiatableStandalone)result).set(0, actor);
            } else if (ActorUtils.isSource(actor)) {
                result = new InstantiatableSource();
                ((InstantiatableSource)result).set(0, actor);
            } else if (ActorUtils.isTransformer(actor)) {
                result = new InstantiatableTransformer();
                ((InstantiatableTransformer)result).set(0, actor);
            } else if (ActorUtils.isSink(actor)) {
                result = new InstantiatableSink();
                ((InstantiatableSink)result).set(0, actor);
            }
        }
        return result;
    }

    public static AbstractActor locate(ActorPath path, AbstractActor parent) {
        AbstractActor child;
        AbstractActor result = null;
        if (!(parent instanceof ActorHandler)) {
            return result;
        }
        ActorHandler parentHandler = (ActorHandler)((Object)parent);
        int index = -1;
        for (int i = 0; i < parentHandler.size(); ++i) {
            child = parentHandler.get(i);
            if (!child.getName().equals(path.getFirstPathComponent())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            child = parentHandler.get(index);
            result = path.getPathCount() == 1 ? child : ActorUtils.locate(path.getChildPath(), child);
        } else {
            System.err.println("Malformed path?");
        }
        return result;
    }

    public static AbstractActor locate(String path, AbstractActor root) {
        return ActorUtils.locate(new ActorPath(path), root);
    }

    public static String checkForSource(AbstractActor actor) {
        return ActorUtils.checkForSource(new AbstractActor[]{actor});
    }

    public static String checkForSource(AbstractActor[] actors) {
        String result = null;
        for (int i = 0; i < actors.length; ++i) {
            AbstractActor actor = actors[i];
            if (actor.getSkip() || ActorUtils.isStandalone(actor)) continue;
            String name = actor.getName();
            while (actor instanceof ActorHandler) {
                ActorHandler handler = (ActorHandler)((Object)actor);
                AbstractActor previous = actor;
                actor = handler.firstActive();
                if (actor == null) {
                    actor = previous;
                    break;
                }
                name = name + "." + actor.getName();
            }
            if (ActorUtils.isSource(actor)) break;
            result = "First active, non-standalone actor must be a source, but '" + name + "' is not!";
            break;
        }
        return result;
    }

    public static AbstractActor cleanUpFlow(AbstractActor actor) {
        AbstractActor result = null;
        MultiProcessor processor = new MultiProcessor();
        processor.setSubProcessors(new AbstractActorProcessor[]{new RemoveDisabledActors(), new RemoveUnusedGlobalActors(), new FixDeprecatedCommandlineTransformers(), new FlattenStructure()});
        processor.process(actor);
        if (processor.isModified()) {
            result = processor.getModifiedActor();
        }
        return result;
    }
}

