/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.Token;
import adams.flow.sink.AbstractTextualDisplay;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BufferHistoryPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistoryDisplay
extends AbstractTextualDisplay {
    private static final long serialVersionUID = 3365817040968234289L;
    protected HistorySplitPanel m_HistoryPanel;
    protected JMenuItem m_MenuItemFilePrint;
    protected JMenuItem m_MenuItemEditCopy;
    protected JMenuItem m_MenuItemEditSelectAll;
    protected JMenuItem m_MenuItemViewFont;
    protected JCheckBoxMenuItem m_MenuItemViewCaret;
    protected boolean m_CaretAtStart;

    public String globalInfo() {
        return "Actor that outputs any object that arrives at its input port via the 'toString()' method in a separate 'history' entry.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("caret-at-start", "caretAtStart", false);
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void setCaretAtStart(boolean value) {
        this.m_CaretAtStart = value;
        this.reset();
    }

    public boolean isCaretAtStart() {
        return this.m_CaretAtStart;
    }

    public String caretAtStartTipText() {
        return "If set to true, then the caret will be positioned by default at the start and not the end (can be changed in dialog: View -> Position caret at start).";
    }

    public void clearPanel() {
        this.m_HistoryPanel.clear();
    }

    protected BasePanel newPanel() {
        this.m_HistoryPanel = new HistorySplitPanel(this);
        this.m_HistoryPanel.getHistory().setCaretAtStart(this.m_CaretAtStart);
        this.m_HistoryPanel.getHistory().addHistoryEntrySelectionListener(new AbstractNamedHistoryPanel.HistoryEntrySelectionListener(){

            public void historyEntrySelected(AbstractNamedHistoryPanel.HistoryEntrySelectionEvent e) {
                HistoryDisplay.this.updateMenu();
            }
        });
        return this.m_HistoryPanel;
    }

    protected JMenu createFileMenu() {
        JMenu result = super.createFileMenu();
        JMenuItem menuitem = new JMenuItem("Print...");
        menuitem.setMnemonic('P');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed P"));
        menuitem.setIcon(GUIHelper.getIcon("print.gif"));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryDisplay.this.m_HistoryPanel.getTextPanel().printText();
            }
        });
        int pos = this.indexOfMenuItem(result, this.m_MenuItemFileClose);
        result.insertSeparator(pos);
        result.insert(menuitem, pos);
        this.m_MenuItemFilePrint = menuitem;
        return result;
    }

    protected JMenu createEditMenu() {
        final TextEditorPanel fPanel = this.m_HistoryPanel.getTextPanel();
        JMenu result = new JMenu("Edit");
        result.setMnemonic('E');
        result.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                HistoryDisplay.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed C"));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                fPanel.copy();
            }
        });
        result.add(menuitem);
        this.m_MenuItemEditCopy = menuitem;
        menuitem = new JMenuItem("Select all", GUIHelper.getEmptyIcon());
        menuitem.setMnemonic('S');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed A"));
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                fPanel.selectAll();
            }
        });
        result.addSeparator();
        result.add(menuitem);
        this.m_MenuItemEditSelectAll = menuitem;
        return result;
    }

    protected JMenu createViewMenu() {
        JMenu result = new JMenu("View");
        result.setMnemonic('V');
        result.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                HistoryDisplay.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Choose font...");
        result.add(menuitem);
        menuitem.setIcon(GUIHelper.getIcon("font.png"));
        menuitem.setMnemonic('f');
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryDisplay.this.m_HistoryPanel.getTextPanel().selectFont();
            }
        });
        this.m_MenuItemViewFont = menuitem;
        menuitem = new JCheckBoxMenuItem("Position caret at start");
        result.addSeparator();
        result.add(menuitem);
        menuitem.setMnemonic('s');
        menuitem.setSelected(this.m_CaretAtStart);
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryDisplay.this.m_HistoryPanel.getHistory().setCaretAtStart(HistoryDisplay.this.m_MenuItemViewCaret.isSelected());
            }
        });
        this.m_MenuItemViewCaret = (JCheckBoxMenuItem)menuitem;
        return result;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = super.createMenuBar();
        result.add(this.createEditMenu());
        result.add(this.createViewMenu());
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        super.updateMenu();
        TextEditorPanel panel = this.m_HistoryPanel.getTextPanel();
        this.m_MenuItemFileClear.setEnabled(this.m_HistoryPanel.count() > 0);
        this.m_MenuItemEditCopy.setEnabled(panel.canCopy());
    }

    protected boolean supportsClear() {
        return true;
    }

    protected void clear() {
        this.m_HistoryPanel.clear();
    }

    public String supplyText() {
        String result = null;
        int index = this.m_HistoryPanel.getHistory().getSelectedIndex();
        if (index != -1) {
            result = ((StringBuffer)this.m_HistoryPanel.getHistory().getEntry(index)).toString();
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void display(Token token) {
        HistorySplitPanel historySplitPanel = this.m_HistoryPanel;
        synchronized (historySplitPanel) {
            this.m_HistoryPanel.addResult(token.getPayload().toString());
        }
    }

    protected void cleanUpGUI() {
        if (this.m_HistoryPanel != null) {
            this.m_HistoryPanel.clear();
        }
        super.cleanUpGUI();
    }

    public static class HistorySplitPanel
    extends BasePanel {
        private static final long serialVersionUID = 5121061351955687610L;
        protected HistoryDisplay m_Owner;
        protected JSplitPane m_SplitPane;
        protected BufferHistoryPanel m_History;
        protected TextEditorPanel m_TextPanel;
        protected SimpleDateFormat m_Format;

        public HistorySplitPanel(HistoryDisplay owner) {
            super(new BorderLayout());
            this.m_Owner = owner;
            this.m_Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            this.m_SplitPane = new JSplitPane();
            this.add((Component)this.m_SplitPane, "Center");
            this.m_TextPanel = new TextEditorPanel();
            this.m_TextPanel.setTextFont(owner.getFont());
            this.m_TextPanel.setEditable(false);
            this.m_SplitPane.setBottomComponent(this.m_TextPanel);
            this.m_History = new BufferHistoryPanel();
            this.m_History.setTextArea(this.m_TextPanel.getTextArea());
            this.m_SplitPane.setTopComponent(this.m_History);
            this.m_SplitPane.setResizeWeight(0.1);
            this.m_SplitPane.setDividerLocation(150);
        }

        public HistoryDisplay getOwner() {
            return this.m_Owner;
        }

        public TextEditorPanel getTextPanel() {
            return this.m_TextPanel;
        }

        public void clear() {
            this.m_History.clear();
            this.m_TextPanel.clear();
        }

        public int count() {
            return this.m_History.count();
        }

        public void addResult(String result) {
            this.addResult(new StringBuffer(result));
        }

        public BufferHistoryPanel getHistory() {
            return this.m_History;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addResult(StringBuffer result) {
            String baseID;
            SimpleDateFormat simpleDateFormat = this.m_Format;
            synchronized (simpleDateFormat) {
                baseID = this.m_Format.format(new Date());
            }
            String id = baseID;
            int count = 1;
            while (this.m_History.hasEntry(id)) {
                id = baseID + " (" + ++count + ")";
            }
            this.m_History.addEntry(id, result);
            this.m_History.setSelectedIndex(this.count() - 1);
        }
    }
}

