/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class StringJoin
extends AbstractTransformer {
    private static final long serialVersionUID = -5524254075032084295L;
    protected String m_Glue;

    public String globalInfo() {
        return "Creates a single string out of an array of strings.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("glue", "glue", "");
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("glue");
        if (variable != null) {
            return variable;
        }
        if (this.m_Glue != null && this.m_Glue.length() > 0) {
            return Utils.backQuoteChars(this.m_Glue);
        }
        return null;
    }

    public void setGlue(String value) {
        this.m_Glue = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getGlue() {
        return Utils.backQuoteChars(this.m_Glue);
    }

    public String glueTipText() {
        return "The string to use for 'glueing' the array elements together; \\t\\n\\r\\b\\f get automatically converted into their character counterparts.";
    }

    public Class[] accepts() {
        return new Class[]{String[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            String[] array = (String[])this.m_InputToken.getPayload();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    str.append(this.m_Glue);
                }
                str.append(array[i]);
            }
            this.m_OutputToken = new Token(str.toString());
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

