/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JComponentList
extends JList {
    private static final long serialVersionUID = -5162054751544750195L;
    protected JComponentList m_Self = this;

    public JComponentList() {
        this(new JComponentListModel());
    }

    public JComponentList(JComponentListModel model) {
        super(model);
        this.setCellRenderer(new ListCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PopupMenuProvider provider;
                Object element;
                int index;
                if (MouseUtils.isRightClick(e) && (index = JComponentList.this.m_Self.locationToIndex(e.getPoint())) > -1 && (element = JComponentList.this.m_Self.getModel().getElementAt(index)) instanceof PopupMenuProvider && (provider = (PopupMenuProvider)element).hasPopupMenu()) {
                    e.consume();
                    JPopupMenu menu = provider.getPopupMenu();
                    menu.show(JComponentList.this.m_Self, e.getX(), e.getY());
                }
                super.mouseClicked(e);
            }
        });
    }

    public void setModel(ListModel model) {
        if (!(model instanceof JComponentListModel)) {
            throw new IllegalArgumentException("Model must be of type " + JComponentListModel.class.getName() + "!");
        }
        super.setModel(model);
    }

    public void setListData(Object[] listData) {
        throw new IllegalArgumentException("Only setModel(JComponentListModel) is allowed!");
    }

    public void setListData(Vector<?> listData) {
        throw new IllegalArgumentException("Only setModel(JComponentListModel) is allowed!");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        frame.setSize(400, 300);
        JComponentListModel model = new JComponentListModel();
        JComponentList list = new JComponentList(model);
        frame.add((Component)new BaseScrollPane(list), "Center");
        frame.setVisible(true);
        for (int i = 0; i < 10; ++i) {
            model.addElement(new JLabel("" + i));
        }
        model.addElement(new JLabel(GUIHelper.getIcon("exit.png"), 2));
        model.addElement(new JLabel(GUIHelper.getIcon("hand.gif"), 2));
    }

    public static class ListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -5578231619307079271L;

        public ListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)value;
            comp.setOpaque(true);
            if (isSelected) {
                comp.setBackground(list.getSelectionBackground());
            } else {
                comp.setBackground(list.getBackground());
            }
            return comp;
        }
    }

    public static class JComponentListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 962859537727414215L;

        public void add(int index, Object element) {
            if (!(element instanceof JComponent)) {
                throw new IllegalArgumentException("Only descendants of JComponent are allowed!");
            }
            super.add(index, element);
        }

        public void addElement(Object obj) {
            if (!(obj instanceof JComponent)) {
                throw new IllegalArgumentException("Only descendants of JComponent are allowed!");
            }
            super.addElement(obj);
        }

        public Object set(int index, Object element) {
            if (!(element instanceof JComponent)) {
                throw new IllegalArgumentException("Only descendants of JComponent are allowed!");
            }
            return super.set(index, element);
        }

        public void setElementAt(Object obj, int index) {
            if (!(obj instanceof JComponent)) {
                throw new IllegalArgumentException("Only descendants of JComponent are allowed!");
            }
            super.setElementAt(obj, index);
        }
    }

    public static abstract class CheckBoxListItem
    extends JCheckBox
    implements PopupMenuProvider,
    ActionListener {
        private static final long serialVersionUID = -5615085802034434150L;
        protected JComponentList m_List;
        protected HashSet<Actions> m_Disabled;
        protected Hashtable<Actions, String> m_Display;

        public CheckBoxListItem(JComponentList list) {
            this.m_List = list;
            this.m_Disabled = new HashSet();
            this.m_Display = new Hashtable();
        }

        public JComponentList getList() {
            return this.m_List;
        }

        public boolean isEnabled(Actions action) {
            return !this.m_Disabled.contains((Object)action);
        }

        public void setEnabled(Actions action, boolean enabled) {
            if (enabled) {
                this.m_Disabled.remove((Object)action);
            } else {
                this.m_Disabled.add(action);
            }
        }

        public boolean hasDisplayOverride(Actions action) {
            return this.m_Display.containsKey((Object)action);
        }

        public void addDisplayOverride(Actions action, String display) {
            this.m_Display.put(action, display);
        }

        public void removeDisplayOverride(Actions action) {
            this.m_Display.remove((Object)action);
        }

        public String getDisplayOverride(Actions action) {
            return this.m_Display.get((Object)action);
        }

        public boolean hasPopupMenu() {
            return true;
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu result = new JPopupMenu();
            for (Actions action : Actions.values()) {
                if (!this.isEnabled(action)) continue;
                JMenuItem item = new JMenuItem();
                if (this.hasDisplayOverride(action)) {
                    item.setText(this.getDisplayOverride(action));
                } else {
                    item.setText(action.getDisplay());
                }
                item.setActionCommand(action.toString());
                item.addActionListener(this);
                result.add(item);
                if (action != Actions.TOGGLE) continue;
                result.addSeparator();
            }
            return result;
        }

        public abstract void actionPerformed(ActionEvent var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Actions {
            TOGGLE("Toggle"),
            REMOVE("Remove"),
            REMOVE_ALL("Remove all");

            protected String m_Display;

            private Actions(String display) {
                this.m_Display = display;
            }

            public String getDisplay() {
                return this.m_Display;
            }
        }
    }

    public static abstract class LabelListItem
    extends JLabel
    implements PopupMenuProvider,
    ActionListener {
        private static final long serialVersionUID = -1281892849183281829L;
        protected JComponentList m_List;
        protected HashSet<Actions> m_Disabled;
        protected Hashtable<Actions, String> m_Display;

        public LabelListItem(JComponentList list) {
            this.m_List = list;
            this.m_Disabled = new HashSet();
            this.m_Display = new Hashtable();
        }

        public JComponentList getList() {
            return this.m_List;
        }

        public boolean isEnabled(Actions action) {
            return !this.m_Disabled.contains((Object)action);
        }

        public void setEnabled(Actions action, boolean enabled) {
            if (enabled) {
                this.m_Disabled.remove((Object)action);
            } else {
                this.m_Disabled.add(action);
            }
        }

        public boolean hasDisplayOverride(Actions action) {
            return this.m_Display.containsKey((Object)action);
        }

        public void addDisplayOverride(Actions action, String display) {
            this.m_Display.put(action, display);
        }

        public void removeDisplayOverride(Actions action) {
            this.m_Display.remove((Object)action);
        }

        public String getDisplayOverride(Actions action) {
            return this.m_Display.get((Object)action);
        }

        public boolean hasPopupMenu() {
            return true;
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu result = new JPopupMenu();
            for (Actions action : Actions.values()) {
                if (!this.isEnabled(action)) continue;
                JMenuItem item = new JMenuItem();
                if (this.hasDisplayOverride(action)) {
                    item.setText(this.getDisplayOverride(action));
                } else {
                    item.setText(action.getDisplay());
                }
                item.setActionCommand(action.toString());
                item.addActionListener(this);
                result.add(item);
            }
            return result;
        }

        public abstract void actionPerformed(ActionEvent var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Actions {
            REMOVE("Remove"),
            REMOVE_ALL("Remove all");

            protected String m_Display;

            private Actions(String display) {
                this.m_Display = display;
            }

            public String getDisplay() {
                return this.m_Display;
            }
        }
    }

    public static interface PopupMenuProvider {
        public boolean hasPopupMenu();

        public JPopupMenu getPopupMenu();
    }
}

