/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.provenance;

import adams.core.Properties;
import adams.core.Utils;
import adams.env.Environment;
import adams.gui.core.BaseTree;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.dialog.TextDialog;
import adams.gui.flow.provenance.ProvenanceNode;
import adams.gui.flow.provenance.ProvenanceRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ProvenanceTree
extends BaseTree {
    private static final long serialVersionUID = 2341627238523950383L;
    public static final String FILENAME = "ProvenanceTree.props";
    protected static Properties m_Properties;
    protected ProvenanceTree m_Self;
    protected String m_ActorTypeColor;
    protected String m_ActorTypeSize;
    protected String m_OptionsColor;
    protected String m_OptionsSize;
    protected String m_InputOutputColor;
    protected String m_InputOutputSize;
    protected String[] m_InputOutputPrefixes;

    public ProvenanceTree() {
        this((ProvenanceNode)null);
    }

    public ProvenanceTree(ProvenanceNode root) {
        if (root == null) {
            root = new ProvenanceNode(this);
        }
        this.setRoot(root);
    }

    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        Properties props = ProvenanceTree.getProperties();
        this.m_ActorTypeColor = props.getProperty("Tree.ActorType.Color", "blue");
        this.m_ActorTypeSize = props.getProperty("Tree.ActorType.Size", "2");
        this.m_OptionsColor = props.getProperty("Tree.Options.Color", "black");
        this.m_OptionsSize = props.getProperty("Tree.Options.Size", "3");
        this.m_InputOutputColor = props.getProperty("Tree.InputOutput.Color", "#008800");
        this.m_InputOutputSize = props.getProperty("Tree.InputOutput.Size", "-2");
        this.m_InputOutputPrefixes = props.getProperty("Tree.InputOutput.Prefixes", "java.lang.,java.io.,adams.core.io.,adams.flow.core.,adams.flow.container.").replace(" ", "").split(",");
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (ProvenanceTree.this.m_Self.isEnabled() && MouseUtils.isRightClick(e)) {
                    e.consume();
                    ProvenanceTree.this.showNodePopupMenu(e);
                } else {
                    super.mousePressed(e);
                }
            }
        });
        this.setCellRenderer(new ProvenanceRenderer());
    }

    public void setActorTypeColor(String value) {
        this.m_ActorTypeColor = value;
    }

    public String getActorTypeColor() {
        return this.m_ActorTypeColor;
    }

    public void setActorTypeSize(String value) {
        this.m_ActorTypeSize = value;
    }

    public String getActorTypeSize() {
        return this.m_ActorTypeSize;
    }

    public void setInputOutputColor(String value) {
        this.m_InputOutputColor = value;
    }

    public String getInputOutputColor() {
        return this.m_InputOutputColor;
    }

    public void setInputOutputSize(String value) {
        this.m_InputOutputSize = value;
    }

    public String getInputOutputSize() {
        return this.m_InputOutputSize;
    }

    public void setInputOutputPrefixes(String[] value) {
        this.m_InputOutputPrefixes = (String[])value.clone();
    }

    public String[] getInputOutputPrefixes() {
        return this.m_InputOutputPrefixes;
    }

    public void setOptionsColor(String value) {
        this.m_OptionsColor = value;
    }

    public String getOptionsColor() {
        return this.m_OptionsColor;
    }

    public void setOptionsSize(String value) {
        this.m_OptionsSize = value;
    }

    public String getOptionsSize() {
        return this.m_OptionsSize;
    }

    public void clear() {
        this.setRoot(new ProvenanceNode(this));
    }

    public void setRoot(ProvenanceNode root) {
        if (root != null) {
            root.setOwner(this);
            this.setModel(new DefaultTreeModel(root));
            this.expandAll();
        } else {
            this.setModel(null);
        }
    }

    protected void showNodePopupMenu(MouseEvent e) {
        JPopupMenu menu = null;
        int selRow = this.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        final ProvenanceNode selNode = (ProvenanceNode)selPath.getLastPathComponent();
        if (selRow > -1) {
            menu = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem(selNode.getProvenanceInformation().getClassname(), GUIHelper.getIcon("provenance.png"));
            menuitem.setEnabled(false);
            menu.add(menuitem);
            menu.addSeparator();
            menuitem = new JMenuItem("Show options...", GUIHelper.getIcon("editor.gif"));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TextDialog dialog = ProvenanceTree.this.getParentDialog() != null ? new TextDialog(ProvenanceTree.this.getParentDialog()) : new TextDialog(ProvenanceTree.this.getParentFrame());
                    dialog.setContent(Utils.flatten(selNode.getProvenanceInformation().getOptions(), "\n"));
                    dialog.setLocationRelativeTo(ProvenanceTree.this);
                    dialog.setVisible(true);
                }
            });
            menu.add(menuitem);
        }
        if (menu != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("provenance tree");
        }
        return m_Properties;
    }
}

