/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.core.NumberTextField;
import adams.gui.goe.AbstractNumberEditor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public abstract class AbstractFloatingPointNumberEditor
extends AbstractNumberEditor {
    protected abstract NumberTextField.Type getType();

    protected NumberTextField.BoundedNumberCheckModel createCheckModel() {
        return new NumberTextField.BoundedNumberCheckModel(this.getType(), this.getLowerBound(), this.getUpperBound(), this.getDefaultValue());
    }

    protected void updateBounds() {
        ((NumberTextField)this.m_CustomEditor).setCheckModel(this.createCheckModel());
    }

    protected JComponent createCustomEditor() {
        final NumberTextField result = new NumberTextField(this.getType());
        result.setCheckModel(this.createCheckModel());
        result.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (!result.isValid()) {
                    result.setDefaultValue();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        result.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                this.set(e.getDocument());
            }

            public void insertUpdate(DocumentEvent e) {
                this.set(e.getDocument());
            }

            public void changedUpdate(DocumentEvent e) {
                this.set(e.getDocument());
            }

            protected void set(Document doc) {
                try {
                    Object value;
                    if (result.isValid() && !(value = AbstractFloatingPointNumberEditor.this.parse(doc.getText(0, doc.getLength()))).equals(AbstractFloatingPointNumberEditor.this.getValue())) {
                        AbstractFloatingPointNumberEditor.this.setValue(value);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return result;
    }
}

