/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Variables;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.gui.core.GUIHelper;
import adams.gui.goe.PropertySheetPanel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class VariableSupport {
    public static final String CAPTION_INDICATOR = "*";
    public static final String HINT_INDICATOR = ", variable: ";

    public static PropertySheetPanel findParent(Container c) {
        return (PropertySheetPanel)GUIHelper.getParent(c, PropertySheetPanel.class);
    }

    public static boolean hasVariable(PropertySheetPanel parent, PropertyEditor editor) {
        if (parent != null) {
            return parent.findOption(editor) != null;
        }
        return false;
    }

    public static JPopupMenu createPopup(PropertySheetPanel parent, PropertyEditor editor) {
        AbstractOption option;
        JPopupMenu result = null;
        if (parent != null && (option = parent.findOption(editor)) != null) {
            result = VariableSupport.updatePopup(parent, editor, new JPopupMenu());
        }
        return result;
    }

    public static JPopupMenu updatePopup(final PropertySheetPanel parent, PropertyEditor editor, JPopupMenu menu) {
        AbstractArgumentOption argoption;
        JPopupMenu result = menu;
        if (parent == null) {
            return result;
        }
        AbstractOption option = parent.findOption(editor);
        JLabel label = parent.findLabel(editor);
        if (option instanceof AbstractArgumentOption && !(argoption = (AbstractArgumentOption)option).isMultiple()) {
            final AbstractArgumentOption fArgOption = argoption;
            final JLabel fLabel = label;
            final PropertySheetPanel fParent = parent;
            if (result.getComponentCount() > 0) {
                result.addSeparator();
            }
            if (!argoption.isVariableAttached()) {
                JMenuItem item = new JMenuItem("Set variable...", GUIHelper.getIcon("variable.gif"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String name = JOptionPane.showInputDialog(fParent, (Object)"Please enter the variable name:");
                        if (name == null) {
                            return;
                        }
                        if (!Variables.isValidName(name)) {
                            GUIHelper.showErrorMessage(fParent, "Not a valid variable name: " + name + "\n" + "Allowed characters:\n" + "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789");
                            return;
                        }
                        fArgOption.setVariable(name);
                        VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                        parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                    }
                });
                result.add(item);
            } else {
                JMenuItem item = new JMenuItem("Change variable '" + fArgOption.getVariableName() + "'...", GUIHelper.getIcon("variable.gif"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String oldName = fArgOption.getVariableName();
                        String name = JOptionPane.showInputDialog(fParent, "Please enter the new variable name:", oldName);
                        if (name == null) {
                            return;
                        }
                        if (!Variables.isValidName(name)) {
                            GUIHelper.showErrorMessage(fParent, "Not a valid variable name: " + name + "\n" + "Allowed characters:\n" + "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789");
                            return;
                        }
                        fArgOption.setVariable(name);
                        VariableSupport.updateLabel(fLabel, fArgOption.getVariableName());
                        parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                    }
                });
                result.add(item);
                item = new JMenuItem("Remove variable '" + argoption.getVariableName() + "'", GUIHelper.getIcon("delete.gif"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        fArgOption.setVariable(null);
                        VariableSupport.updateLabel(fLabel, null);
                        parent.getPropertyChangeSupport().firePropertyChange("", null, null);
                    }
                });
                result.add(item);
            }
        }
        return result;
    }

    public static void updateLabel(JLabel label, String variable) {
        boolean hasVariable = variable != null;
        String text = label.getText();
        boolean hintPresent = text.endsWith(CAPTION_INDICATOR);
        if (hintPresent) {
            text = text.substring(0, text.length() - CAPTION_INDICATOR.length());
        }
        if (hasVariable) {
            text = text + CAPTION_INDICATOR;
        }
        label.setText(text);
        text = label.getToolTipText();
        boolean bl = hintPresent = text.indexOf(HINT_INDICATOR) > -1;
        if (hintPresent) {
            text = text.substring(0, text.indexOf(HINT_INDICATOR));
        }
        if (hasVariable) {
            text = text + HINT_INDICATOR + variable;
        }
        label.setToolTipText(text);
    }
}

