/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.db.LogEntry;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.PropertiesTableModel;
import adams.gui.dialog.TextDialog;
import adams.gui.tools.LogEntryViewerTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractLogEntryViewerPanel
extends BasePanel {
    private static final long serialVersionUID = -3659016045308129874L;
    protected BaseTableWithButtons m_TableEntries;
    protected LogEntryViewerTableModel m_TableModelEntries;
    protected BaseTableWithButtons m_TableMessage;
    protected JButton m_ButtonDisplay;
    protected BaseSplitPane m_SplitPane;
    protected TextDialog m_DetailsDialog;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TableModelEntries = new LogEntryViewerTableModel();
        this.m_TableEntries = new BaseTableWithButtons(this.m_TableModelEntries);
        this.m_TableEntries.setAutoResizeMode(0);
        this.m_TableEntries.setInfoVisible(true);
        this.m_TableEntries.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AbstractLogEntryViewerPanel.this.update();
                if (AbstractLogEntryViewerPanel.this.m_TableEntries.getSelectedRowCount() >= 1) {
                    int[] indices = AbstractLogEntryViewerPanel.this.m_TableEntries.getSelectedRows();
                    LogEntry entry = AbstractLogEntryViewerPanel.this.m_TableModelEntries.getLogEntryAt(indices[0]);
                    AbstractLogEntryViewerPanel.this.displayMessage(entry);
                }
            }
        });
        this.m_TableMessage = new BaseTableWithButtons(new PropertiesTableModel());
        this.m_TableMessage.setSelectionMode(0);
        this.m_TableMessage.setAutoResizeMode(0);
        this.m_TableMessage.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AbstractLogEntryViewerPanel.this.updateButtons();
            }
        });
        this.m_ButtonDisplay = new JButton("Display");
        this.m_ButtonDisplay.setMnemonic('i');
        this.m_ButtonDisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractLogEntryViewerPanel.this.displayKeyValue();
            }
        });
        this.m_TableMessage.addToButtonsPanel(this.m_ButtonDisplay);
        this.m_TableMessage.setDoubleClickButton(this.m_ButtonDisplay);
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setTopComponent(this.m_TableEntries);
        this.m_SplitPane.setBottomComponent(this.m_TableMessage);
        this.add((Component)this.m_SplitPane, "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    protected void displayMessage(final LogEntry entry) {
        Runnable run = new Runnable(){

            public void run() {
                Properties props = entry.getMessageAsProperties();
                PropertiesTableModel model = new PropertiesTableModel(props);
                AbstractLogEntryViewerPanel.this.m_TableMessage.setModel(model);
                AbstractLogEntryViewerPanel.this.m_TableMessage.setOptimalColumnWidth();
                AbstractLogEntryViewerPanel.this.update();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected TextDialog createDetailsDialog() {
        TextDialog result = this.getParentDialog() != null ? new TextDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new TextDialog(this.getParentFrame(), true);
        return result;
    }

    protected void displayKeyValue() {
        int row;
        if (this.m_DetailsDialog == null) {
            this.m_DetailsDialog = this.createDetailsDialog();
        }
        if ((row = this.m_TableMessage.getSelectedRow()) == -1) {
            return;
        }
        PropertiesTableModel model = (PropertiesTableModel)this.m_TableMessage.getModel();
        this.m_DetailsDialog.setTitle(model.getKeyAt(row));
        this.m_DetailsDialog.setContent((String)model.getValueAt(row));
        this.m_DetailsDialog.setLocationRelativeTo(this);
        this.m_DetailsDialog.setVisible(true);
    }

    protected void update() {
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonDisplay.setEnabled(this.m_TableMessage.getSelectedRowCount() > 0);
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.m_TableEntries.setEnabled(value);
        this.m_TableMessage.setEnabled(value);
        this.update();
    }
}

