/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.ArrayConsumer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OptionsConversionPanel
extends BasePanel {
    private static final long serialVersionUID = -2881786410361917678L;
    protected GenericObjectEditorPanel m_InputFormat;
    protected BaseTextAreaWithButtons m_TextAreaInput;
    protected JButton m_ButtonInputCopy;
    protected JButton m_ButtonInputPaste;
    protected JButton m_ButtonInputOpen;
    protected GenericObjectEditorPanel m_OutputFormat;
    protected BaseTextAreaWithButtons m_TextAreaOutput;
    protected JButton m_ButtonOutputCopy;
    protected JButton m_ButtonOutputPaste;
    protected JButton m_ButtonOutputSave;
    protected JButton m_ButtonConvert;
    protected BaseFileChooser m_FileChooserInput;
    protected BaseFileChooser m_FileChooserOutput;

    protected void initialize() {
        super.initialize();
        this.m_FileChooserInput = new BaseFileChooser();
        this.m_FileChooserOutput = new BaseFileChooser();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panelAll = new JPanel(new GridLayout(2, 1));
        this.add((Component)panelAll, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelAll.add(panel);
        this.m_InputFormat = new GenericObjectEditorPanel(AbstractOptionConsumer.class, new ArrayConsumer(), true);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel.add((Component)panel2, "North");
        panel2.add(this.m_InputFormat);
        this.m_TextAreaInput = new BaseTextAreaWithButtons();
        panel.add((Component)this.m_TextAreaInput, "Center");
        this.m_ButtonInputCopy = new JButton("Copy", GUIHelper.getIcon("copy.gif"));
        this.m_ButtonInputCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(OptionsConversionPanel.this.m_TextAreaInput.getText());
            }
        });
        this.m_TextAreaInput.addToButtonsPanel(this.m_ButtonInputCopy);
        this.m_ButtonInputPaste = new JButton("Paste", GUIHelper.getIcon("paste.gif"));
        this.m_ButtonInputPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsConversionPanel.this.m_TextAreaInput.setText(GUIHelper.pasteFromClipboard());
            }
        });
        this.m_TextAreaInput.addToButtonsPanel(this.m_ButtonInputPaste);
        this.m_ButtonInputOpen = new JButton("Open...", GUIHelper.getIcon("open.gif"));
        this.m_ButtonInputOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int retVal = OptionsConversionPanel.this.m_FileChooserInput.showOpenDialog(OptionsConversionPanel.this);
                if (retVal != 0) {
                    return;
                }
                Vector<String> lines = FileUtils.loadFromFile(OptionsConversionPanel.this.m_FileChooserInput.getSelectedFile());
                OptionsConversionPanel.this.m_TextAreaInput.setText(Utils.flatten(lines, "\n"));
            }
        });
        this.m_TextAreaInput.addToButtonsPanel(this.m_ButtonInputOpen);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelAll.add(panel);
        this.m_OutputFormat = new GenericObjectEditorPanel(AbstractOptionProducer.class, new NestedProducer(), true);
        panel2 = new JPanel(new FlowLayout(0));
        panel.add((Component)panel2, "North");
        panel2.add(this.m_OutputFormat);
        this.m_TextAreaOutput = new BaseTextAreaWithButtons();
        panel.add((Component)this.m_TextAreaOutput, "Center");
        this.m_ButtonOutputCopy = new JButton("Copy", GUIHelper.getIcon("copy.gif"));
        this.m_ButtonOutputCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(OptionsConversionPanel.this.m_TextAreaOutput.getText());
            }
        });
        this.m_TextAreaOutput.addToButtonsPanel(this.m_ButtonOutputCopy);
        this.m_ButtonOutputPaste = new JButton("Paste", GUIHelper.getIcon("paste.gif"));
        this.m_ButtonOutputPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsConversionPanel.this.m_TextAreaOutput.setText(GUIHelper.pasteFromClipboard());
            }
        });
        this.m_TextAreaOutput.addToButtonsPanel(this.m_ButtonOutputPaste);
        this.m_ButtonOutputSave = new JButton("Save...", GUIHelper.getIcon("save.gif"));
        this.m_ButtonOutputSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int retVal = OptionsConversionPanel.this.m_FileChooserOutput.showSaveDialog(OptionsConversionPanel.this);
                if (retVal != 0) {
                    return;
                }
                String filename = OptionsConversionPanel.this.m_FileChooserOutput.getSelectedFile().getAbsolutePath();
                if (!FileUtils.writeToFile(filename, OptionsConversionPanel.this.m_TextAreaOutput.getText(), false)) {
                    GUIHelper.showErrorMessage(OptionsConversionPanel.this, "Failed to write output to '" + filename + "'!");
                }
            }
        });
        this.m_TextAreaOutput.addToButtonsPanel(this.m_ButtonOutputSave);
        panel = new JPanel(new FlowLayout(2));
        this.add((Component)panel, "South");
        this.m_ButtonConvert = new JButton("Convert");
        this.m_ButtonConvert.setMnemonic('C');
        this.m_ButtonConvert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AbstractOptionConsumer consumer = (AbstractOptionConsumer)OptionsConversionPanel.this.m_InputFormat.getCurrent();
                    OptionHandler handler = AbstractOptionConsumer.fromString(consumer.getClass(), OptionsConversionPanel.this.m_TextAreaInput.getText());
                    AbstractOptionProducer producer = (AbstractOptionProducer)OptionsConversionPanel.this.m_OutputFormat.getCurrent();
                    OptionsConversionPanel.this.m_TextAreaOutput.setText(AbstractOptionProducer.toString(producer.getClass(), handler));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIHelper.showErrorMessage(OptionsConversionPanel.this, "Failed to convert options:\n" + ex);
                }
            }
        });
        panel.add(this.m_ButtonConvert);
    }
}

