/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public abstract class AbstractPaintlet
extends OptionHandlingObject
implements Paintlet {
    private static final long serialVersionUID = -8877675053270937462L;
    protected PaintablePanel m_Panel;
    protected boolean m_Enabled;
    protected boolean m_RepaintOnChange;
    protected float m_StrokeThickness;
    protected boolean m_Initializing;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", Float.valueOf(1.0f), Float.valueOf(0.01f), null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Panel = null;
        this.m_Initializing = true;
        this.m_Enabled = true;
        this.m_RepaintOnChange = true;
    }

    protected void finishInit() {
        super.finishInit();
        this.m_Initializing = false;
        this.memberChanged();
    }

    protected boolean isInitializing() {
        return this.m_Initializing;
    }

    public void setPanel(PaintablePanel value) {
        if (value != this.m_Panel) {
            if (this.m_Panel != null) {
                this.m_Panel.removePaintlet(this);
            }
            this.m_Panel = value;
            if (this.m_Panel != null) {
                this.m_Panel.addPaintlet(this);
            }
            this.memberChanged(true);
        }
    }

    public PaintablePanel getPanel() {
        return this.m_Panel;
    }

    public boolean hasPanel() {
        return this.m_Panel != null;
    }

    public PlotPanel getPlot() {
        PlotPanel result = null;
        if (this.m_Panel != null) {
            result = this.m_Panel.getPlot();
        }
        return result;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
        this.repaint();
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public void setRepaintOnChange(boolean value) {
        this.m_RepaintOnChange = value;
    }

    public boolean getRepaintOnChange() {
        return this.m_RepaintOnChange;
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.memberChanged();
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke.";
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    public abstract PaintEvent.PaintMoment getPaintMoment();

    public abstract void performPaint(Graphics var1);

    public void paint(Graphics g) {
        if (this.isEnabled() && this.hasPanel()) {
            Graphics2D g2d = null;
            float width = 1.0f;
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                if (g2d.getStroke() instanceof BasicStroke) {
                    width = ((BasicStroke)g2d.getStroke()).getLineWidth();
                }
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            }
            this.performPaint(g);
            if (g2d != null) {
                g2d.setStroke(new BasicStroke(width));
            }
        }
    }

    protected void updatePanel() {
        if (this.hasPanel()) {
            this.getPanel().update();
        }
    }

    public void memberChanged() {
        this.memberChanged(false);
    }

    public void memberChanged(boolean updatePanel) {
        this.reset();
        if (updatePanel) {
            this.updatePanel();
        }
        if (!this.isInitializing() && this.getRepaintOnChange()) {
            this.repaint();
        }
    }

    public void repaint() {
        if (this.isEnabled() && this.hasPanel()) {
            this.m_Panel.update();
        }
    }

    public AbstractPaintlet shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractPaintlet shallowCopy(boolean expand) {
        return (AbstractPaintlet)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getPaintlets() {
        return ClassLister.getSingleton().getClassnames(AbstractPaintlet.class);
    }

    public static AbstractPaintlet forName(String classname, String[] options) {
        AbstractPaintlet result;
        try {
            result = (AbstractPaintlet)OptionUtils.forName(AbstractPaintlet.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractPaintlet forCommandLine(String cmdline) {
        return (AbstractPaintlet)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

