/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise;

import adams.core.Randomizable;
import adams.optimise.AbstractOptimiser;
import adams.optimise.FitnessFunction;
import adams.optimise.OptData;
import adams.optimise.OptVar;
import java.util.Random;

public class RandomOptimiser
extends AbstractOptimiser
implements Randomizable {
    private static final long serialVersionUID = -6032771539666237896L;
    protected int m_Iterations;
    protected long m_Seed;

    public String globalInfo() {
        return "Generate random parameter values.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("iterations", "iterations", 1000);
        this.m_OptionManager.add("seed", "seed", 1L);
    }

    public void setIterations(int value) {
        this.m_Iterations = value;
        this.reset();
    }

    public int getIterations() {
        return this.m_Iterations;
    }

    public String iterationsTipText() {
        return "The number of iterations to use.";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public OptData optimise(OptData datadef, FitnessFunction fitness) {
        Random rand = new Random(this.m_Seed);
        OptData sofar = datadef;
        for (int i = 0; i < this.getIterations(); ++i) {
            for (String var : datadef.getVarNames()) {
                OptVar ov = datadef.getVar(var);
                Double val = rand.nextDouble();
                val = (ov.m_max - ov.m_min) * val + ov.m_min;
                if (ov.m_isInteger) {
                    sofar.set(var, val.intValue());
                    continue;
                }
                sofar.set(var, val);
            }
            this.checkBest(fitness.evaluate(sofar), sofar, fitness);
        }
        return this.m_bestv;
    }
}

