/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;
import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.BackgroundDistNullModel;
import weka.classifiers.sequence.core.BaumWelchTransition;
import weka.classifiers.sequence.core.BeginAlphabet;
import weka.classifiers.sequence.core.DeleteState;
import weka.classifiers.sequence.core.EmissionState;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.NullModel;
import weka.classifiers.sequence.core.NumericStabilityException;
import weka.classifiers.sequence.core.RandomDistribution;
import weka.classifiers.sequence.core.SequenceLengthException;
import weka.classifiers.sequence.core.SpecialAlphabet;
import weka.classifiers.sequence.core.State;
import weka.classifiers.sequence.core.Transition;
import weka.classifiers.sequence.core.UniformDistribution;
import weka.core.SelectedTag;
import weka.core.Tag;

public class ProfileHMM
implements Serializable {
    private static final long serialVersionUID = -8530352277246148378L;
    private static final double MATCH_TO_MATCH_PROB = 0.3333333333333333;
    private static final double DELETE_TO_MATCH_PROB = 0.5;
    private static final double INSERT_TO_MATCH_PROB = 0.5;
    protected int numberMatchStates;
    private Alphabet alphabet;
    protected EmissionState[] matchStates;
    protected EmissionState[] insertStates;
    protected DeleteState[] deleteStates;
    protected EmissionState end;
    protected EmissionState begin;
    protected Transition[][] transitions;
    protected NullModel nullModel;
    protected boolean useLogSpace = false;
    private static int INIT_UNIFORM = 0;
    private static int INIT_RANDOM = 1;
    public static final Tag[] TAGS_INIT = new Tag[]{new Tag(INIT_UNIFORM, "Initialise PHMM uniformly"), new Tag(INIT_RANDOM, "Initiliase PHMM randmoly")};
    protected int initType = INIT_UNIFORM;

    public int getNumberMatchStates() {
        return this.numberMatchStates;
    }

    public void setNumberMatchStates(int numberMatchStates) throws SequenceLengthException {
        if (numberMatchStates < 4) {
            throw new SequenceLengthException("Provide at least 4 (match) columns.");
        }
        this.numberMatchStates = numberMatchStates;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(Alphabet alpha) {
        this.alphabet = alpha;
    }

    public boolean isUseLogSpace() {
        return this.useLogSpace;
    }

    public ProfileHMM() {
    }

    public ProfileHMM(int matchColumns, Alphabet alpha, boolean useNullModel, boolean useLogSpace) {
        this.setAlphabet(alpha);
        this.useLogSpace = useLogSpace;
        try {
            this.setNumberMatchStates(matchColumns);
        }
        catch (SequenceLengthException e) {
            e.printStackTrace();
        }
        this.nullModel = useNullModel ? new NullModel(useLogSpace, this.alphabet) : null;
        this.initType = INIT_UNIFORM;
        try {
            this.buildStates();
            if (!useLogSpace) {
                this.buildTransitions();
            } else {
                this.buildTransitionsLogSpace();
            }
        }
        catch (InvalidStructureException e) {
            e.printStackTrace();
        }
    }

    public ProfileHMM(int matchColumns, Alphabet alpha, boolean useNullModel, boolean useBackgroundNull, String[] sequences, boolean useLogSpace) {
        this.setAlphabet(alpha);
        this.useLogSpace = useLogSpace;
        try {
            this.setNumberMatchStates(matchColumns);
        }
        catch (SequenceLengthException e) {
            e.printStackTrace();
        }
        if (useNullModel) {
            if (!useBackgroundNull) {
                this.nullModel = new NullModel(useLogSpace, this.alphabet);
            } else {
                try {
                    this.nullModel = new BackgroundDistNullModel(useLogSpace, this.alphabet, sequences);
                }
                catch (IllegalSymbolException e) {
                    System.out.println(e);
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (NumericStabilityException e) {
                    System.out.println(e);
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        } else {
            this.nullModel = null;
        }
        this.initType = INIT_UNIFORM;
        try {
            this.buildStates();
            if (!useLogSpace) {
                this.buildTransitions();
            } else {
                this.buildTransitionsLogSpace();
            }
        }
        catch (InvalidStructureException e) {
            e.printStackTrace();
        }
    }

    public ProfileHMM(int matchColumns, Alphabet alpha, boolean useNullModel, boolean useLogSpace, int initUniformly) {
        this.setAlphabet(alpha);
        this.useLogSpace = useLogSpace;
        try {
            this.setNumberMatchStates(matchColumns);
        }
        catch (SequenceLengthException e) {
            e.printStackTrace();
        }
        this.nullModel = useNullModel ? new NullModel(useLogSpace, this.alphabet) : null;
        this.initType = initUniformly;
        try {
            this.buildStates();
            if (!useLogSpace) {
                this.buildTransitions();
            } else {
                this.buildTransitionsLogSpace();
            }
        }
        catch (InvalidStructureException e) {
            e.printStackTrace();
        }
    }

    private void buildMatchState(int column) {
        if (this.initType == INIT_UNIFORM) {
            this.matchStates[column] = new EmissionState("M", column, this.alphabet, new UniformDistribution(this.alphabet, this.useLogSpace));
        }
        if (this.initType == INIT_RANDOM) {
            this.matchStates[column] = new EmissionState("M", column, this.alphabet, new RandomDistribution(this.alphabet, this.useLogSpace, column));
        }
    }

    private void buildInsertState(int column) {
        if (this.initType == INIT_UNIFORM) {
            this.insertStates[column] = new EmissionState("I", column, this.alphabet, new UniformDistribution(this.alphabet, this.useLogSpace));
        }
        if (this.initType == INIT_RANDOM) {
            this.insertStates[column] = new EmissionState("I", column, this.alphabet, new RandomDistribution(this.alphabet, this.useLogSpace, column));
        }
    }

    protected void buildStates() {
        int i;
        this.matchStates = new EmissionState[this.numberMatchStates];
        this.insertStates = new EmissionState[this.numberMatchStates - 1];
        this.deleteStates = new DeleteState[this.numberMatchStates - 2];
        for (i = 0; i < this.deleteStates.length; ++i) {
            this.deleteStates[i] = new DeleteState("D", i);
        }
        for (i = 0; i < this.matchStates.length; ++i) {
            this.buildMatchState(i);
            if (i >= this.insertStates.length) continue;
            this.buildInsertState(i);
        }
        SpecialAlphabet endAlphabet = new SpecialAlphabet();
        this.end = new EmissionState("E", 0, endAlphabet, new UniformDistribution(endAlphabet, this.useLogSpace));
        BeginAlphabet beginAlphabet = new BeginAlphabet();
        this.begin = new EmissionState("B", 0, beginAlphabet, new UniformDistribution(beginAlphabet, this.useLogSpace));
    }

    protected void buildTransitions() throws InvalidStructureException {
        int i;
        this.connect(this.begin, this.matchStates[0], 1.0);
        for (i = 0; i < this.matchStates.length - 2; ++i) {
            this.connect(this.matchStates[i], this.matchStates[i + 1], 0.3333333333333333);
            double transitionProb = 0.33333333333333337;
            this.connect(this.matchStates[i], this.insertStates[i], transitionProb);
            this.connect(this.matchStates[i], this.deleteStates[i], transitionProb);
        }
        this.connect(this.matchStates[this.matchStates.length - 2], this.matchStates[this.matchStates.length - 1], 0.3333333333333333);
        this.connect(this.matchStates[this.matchStates.length - 2], this.insertStates[this.insertStates.length - 1], 0.6666666666666667);
        this.connect(this.matchStates[this.matchStates.length - 1], this.end, 1.0);
        for (i = 0; i < this.insertStates.length; ++i) {
            this.connect(this.insertStates[i], this.matchStates[i + 1], 0.5);
            this.connect(this.insertStates[i], this.insertStates[i], 0.5);
        }
        for (i = 0; i < this.deleteStates.length - 1; ++i) {
            this.connect(this.deleteStates[i], this.matchStates[i + 2], 0.5);
            this.connect(this.deleteStates[i], this.deleteStates[i + 1], 0.5);
        }
        this.connect(this.deleteStates[this.deleteStates.length - 1], this.matchStates[this.matchStates.length - 1], 1.0);
    }

    protected void buildTransitionsLogSpace() throws InvalidStructureException {
        int i;
        this.connect(this.begin, this.matchStates[0], 0.0);
        for (i = 0; i < this.matchStates.length - 2; ++i) {
            this.connect(this.matchStates[i], this.matchStates[i + 1], Math.log(0.3333333333333333));
            double transitionProb = Math.log(0.33333333333333337);
            this.connect(this.matchStates[i], this.insertStates[i], transitionProb);
            this.connect(this.matchStates[i], this.deleteStates[i], transitionProb);
        }
        this.connect(this.matchStates[this.matchStates.length - 2], this.matchStates[this.matchStates.length - 1], Math.log(0.3333333333333333));
        this.connect(this.matchStates[this.matchStates.length - 2], this.insertStates[this.insertStates.length - 1], Math.log(0.6666666666666667));
        this.connect(this.matchStates[this.matchStates.length - 1], this.end, 0.0);
        for (i = 0; i < this.insertStates.length; ++i) {
            this.connect(this.insertStates[i], this.matchStates[i + 1], Math.log(0.5));
            this.connect(this.insertStates[i], this.insertStates[i], Math.log(0.5));
        }
        for (i = 0; i < this.deleteStates.length - 1; ++i) {
            this.connect(this.deleteStates[i], this.matchStates[i + 2], Math.log(0.5));
            this.connect(this.deleteStates[i], this.deleteStates[i + 1], Math.log(0.5));
        }
        this.connect(this.deleteStates[this.deleteStates.length - 1], this.matchStates[this.matchStates.length - 1], 0.0);
    }

    private void connect(State start, State end, double probability) throws InvalidStructureException {
        BaumWelchTransition transition = new BaumWelchTransition(probability, start, end);
        start.addOutgoingTransition(transition);
        end.addIncomingTransition(transition);
    }

    public EmissionState getMatchState(int i) {
        return this.matchStates[i];
    }

    public EmissionState getEndState() {
        return this.end;
    }

    public EmissionState getBeginState() {
        return this.begin;
    }

    public EmissionState getInsertState(int i) {
        return this.insertStates[i];
    }

    public DeleteState getDeleteState(int i) {
        return this.deleteStates[i];
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.matchStates[0].toString());
        output.append(this.insertStates[0].toString());
        for (int i = 1; i < this.numberMatchStates - 1; ++i) {
            output.append(this.matchStates[i].toString());
            output.append(this.insertStates[i].toString());
            output.append(this.deleteStates[i - 1].toString());
        }
        output.append(this.matchStates[this.numberMatchStates - 1].toString());
        output.append(this.end.toString());
        return output.toString();
    }

    public String emmissionsToString() {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < this.numberMatchStates - 1; ++i) {
            output.append(this.matchStates[i].outputEmissionInformation());
            output.append(this.insertStates[i].outputEmissionInformation());
        }
        output.append(this.matchStates[this.numberMatchStates - 1].outputEmissionInformation());
        output.append(this.end.outputEmissionInformation());
        return output.toString();
    }

    public NullModel getNullModel() {
        return this.nullModel;
    }

    public void setNullModel(NullModel nullModel) {
        this.nullModel = nullModel;
    }

    public SelectedTag getInitType() {
        return new SelectedTag(this.initType, TAGS_INIT);
    }

    public void setInitType(SelectedTag newType) {
        if (newType.getTags() == TAGS_INIT) {
            this.initType = newType.getSelectedTag().getID();
        }
    }

    public static long getSerialVersionUID() {
        return -8530352277246148378L;
    }
}

