/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.annotation.MixedCopyright;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.SSHConnection;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import java.io.InputStream;
import java.io.OutputStream;

@MixedCopyright
public class SSHExec
extends AbstractSource {
    private static final long serialVersionUID = -132045002653940359L;
    protected String m_Command;
    protected Token m_OutputToken;
    protected SSHConnection m_Connection;

    public String globalInfo() {
        return "Runs a system command via ssh on a remote machine and broadcasts the generated output (stdout or stderr).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", (Object)"ls -l .");
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("command");
        String result = variable != null ? variable : this.m_Command;
        return result;
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to run.";
    }

    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((AbstractActor)this, SSHConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SSHConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            Channel channel = this.m_Connection.getSession().openChannel("exec");
            ((ChannelExec)channel).setCommand(this.m_Command);
            channel.setXForwarding(this.m_Connection.getForwardX());
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            InputStream in = channel.getInputStream();
            byte[] buffer = new byte[1024];
            StringBuilder output = new StringBuilder();
            channel.connect();
            while (true) {
                int read;
                if (in.available() > 0 && (read = in.read(buffer, 0, buffer.length)) >= 0) {
                    output.append(new String(buffer, 0, read));
                    continue;
                }
                if (channel.isClosed()) {
                    if (channel.getExitStatus() == 0) break;
                    result = "Exit code: " + channel.getExitStatus();
                    break;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            channel.disconnect();
            if (result == null) {
                this.m_OutputToken = new Token((Object)output.toString());
            }
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

