/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.annotation.MixedCopyright;
import adams.core.io.PlaceholderDirectory;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.SSHConnection;
import adams.flow.transformer.AbstractTransformer;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;

@MixedCopyright
public class SFTPGet
extends AbstractTransformer {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected PlaceholderDirectory m_OutputDirectory;
    protected SSHConnection m_Connection;

    public String globalInfo() {
        return "Downloads a remote file and forwards the local file name via secure FTP (SFTP).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
    }

    public String getQuickInfo() {
        String result = "download from ";
        String variable = this.getOptionManager().getVariableForProperty("remoteDir");
        result = variable != null ? result + variable : result + this.m_RemoteDir;
        result = result + " to ";
        variable = this.getOptionManager().getVariableForProperty("outputDirectory");
        result = variable != null ? result + variable : result + this.m_OutputDirectory;
        return result;
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The SFTP directory to download the file from.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory to store the downloaded files in.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (SSHConnection)ActorUtils.findClosestType((AbstractActor)this, SSHConnection.class);
            if (this.m_Connection == null) {
                result = "No " + SSHConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        String file = (String)this.m_InputToken.getPayload();
        String remotefile = this.m_RemoteDir + "/" + file;
        String outFile = this.m_OutputDirectory.getAbsolutePath() + File.separator + file;
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)this.m_Connection.getSession().openChannel("sftp");
            channel.connect();
            if (this.isDebugOn()) {
                this.debug("Downloading " + remotefile);
            }
            channel.get(remotefile, outFile);
            this.m_OutputToken = new Token((Object)outFile);
            channel.disconnect();
        }
        catch (Exception e) {
            String msg = "Failed to download file '" + remotefile + "' to '" + outFile + "': ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace((Throwable)e);
            result = msg + e;
            this.m_OutputToken = null;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return result;
    }
}

