/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import adams.core.management.Java;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.gui.experiment.HadoopRunLogPanel;
import weka.hadoop.HadoopExperiment;

public class HadoopGuiRunPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1691868018596872051L;
    protected static final String NOT_RUNNING = "Not running";
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    protected HadoopRunLogPanel m_Log = new HadoopRunLogPanel();
    protected Experiment m_Exp;
    protected Thread m_RunThread = null;

    public HadoopGuiRunPanel() {
        this.m_StartBut.addActionListener(this);
        this.m_StopBut.addActionListener(this);
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.setMnemonic('S');
        this.m_StopBut.setMnemonic('t');
        this.m_Log.statusMessage(NOT_RUNNING);
        JPanel controls = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        controls.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        controls.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        controls.add((Component)this.m_StartBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        controls.add((Component)this.m_StopBut, constraints);
        this.setLayout(new BorderLayout());
        this.add((Component)controls, "North");
        this.add((Component)this.m_Log, "Center");
    }

    public HadoopGuiRunPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    public void createJar() {
        try {
            int BUFFER_SIZE = 10240;
            String classPath = Java.getClassPath((boolean)false);
            StringTokenizer token = new StringTokenizer(classPath, ":");
            byte[] buffer = new byte[BUFFER_SIZE];
            File archiveFile = new File(System.getenv("HADOOP_HOME") + "/hadoopGui.jar");
            FileOutputStream stream = new FileOutputStream(archiveFile);
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            token.nextToken();
            StringBuilder value = new StringBuilder("");
            while (token.hasMoreElements()) {
                String currentJarPath = token.nextToken();
                StringTokenizer rebuildJar = new StringTokenizer(currentJarPath, "/");
                String currentRebuildJar = "";
                while (rebuildJar.hasMoreElements()) {
                    currentRebuildJar = rebuildJar.nextToken();
                }
                if (currentRebuildJar.charAt(0) == '.' && currentRebuildJar.charAt(1) == '_') continue;
                value.append("lib/" + currentRebuildJar + " ");
            }
            attributes.putValue("Class-Path", value.toString());
            attributes.putValue("Main-Class", HadoopExperiment.class.getName());
            JarOutputStream out = new JarOutputStream((OutputStream)stream, manifest);
            token = new StringTokenizer(classPath, ":");
            token.nextToken();
            while (token.hasMoreElements()) {
                int nRead;
                String currentFile = token.nextToken();
                File cf = new File(currentFile);
                StringTokenizer rebuildFile = new StringTokenizer(currentFile, "/");
                String currentRebuildFile = "";
                while (rebuildFile.hasMoreTokens()) {
                    currentRebuildFile = rebuildFile.nextToken();
                }
                if (currentRebuildFile.charAt(0) == '.' && currentRebuildFile.charAt(1) == '_') continue;
                JarEntry jarAdd = new JarEntry("lib/" + currentRebuildFile);
                jarAdd.setTime(cf.lastModified());
                out.putNextEntry(jarAdd);
                FileInputStream in = new FileInputStream(cf);
                while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, nRead);
                }
                in.close();
            }
            out.close();
            stream.close();
            System.out.println("Adding completed OK");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_StartBut) {
            if (this.m_RunThread == null) {
                try {
                    this.m_RunThread = new ExperimentRunner(this.m_Exp);
                    this.m_RunThread.setPriority(1);
                    this.m_RunThread.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.logMessage("Problem creating experiment copy to run: " + ex.getMessage());
                }
            }
        } else if (e.getSource() == this.m_StopBut) {
            this.m_StopBut.setEnabled(false);
            this.logMessage("User aborting experiment. ");
            if (this.m_Exp instanceof RemoteExperiment) {
                this.logMessage("Waiting for remote tasks to complete...");
            }
            ((ExperimentRunner)this.m_RunThread).abortExperiment();
            this.m_RunThread = null;
        }
    }

    protected void logMessage(String message) {
        this.m_Log.logMessage(message);
    }

    protected void logMsgWithNoTime(String message) {
        this.m_Log.logMsgWithNoTime(message);
    }

    protected void statusMessage(String message) {
        this.m_Log.statusMessage(message);
    }

    public static void main(String[] args) {
        try {
            boolean readExp = Utils.getFlag((char)'l', (String[])args);
            String expFile = Utils.getOption((char)'f', (String[])args);
            if (readExp && expFile.length() == 0) {
                throw new Exception("A filename must be given with the -f option");
            }
            Object exp = null;
            if (readExp) {
                FileInputStream fi = new FileInputStream(expFile);
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
                Object to = oi.readObject();
                exp = to instanceof RemoteExperiment ? (RemoteExperiment)to : (Experiment)to;
                oi.close();
            } else {
                exp = new Experiment();
            }
            System.err.println("Initial Experiment:\n" + exp.toString());
            final JFrame jf = new JFrame("Run Weka Experiment");
            jf.getContentPane().setLayout(new BorderLayout());
            final HadoopGuiRunPanel sp = new HadoopGuiRunPanel((Experiment)exp);
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.err.println("\nExperiment Configuration\n" + sp.m_Exp.toString());
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class ExperimentRunner
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = -5591889874714150118L;
        Experiment m_ExpCopy;
        Process p;
        String path = System.getenv("HADOOP_HOME");
        File uniqueFile = null;

        public ExperimentRunner(Experiment exp) throws Exception {
            if (exp == null) {
                System.err.println("Null experiment!!!");
            } else {
                System.err.println("Running experiment: " + exp.toString());
            }
            System.err.println("Writing experiment copy");
            SerializedObject so = new SerializedObject((Object)exp);
            System.err.println("Reading experiment copy");
            this.m_ExpCopy = (Experiment)so.getObject();
            System.err.println("Made experiment copy");
            this.uniqueFile = File.createTempFile("input", ".tmp", new File(this.path));
        }

        public void abortExperiment() {
            this.p.destroy();
            HadoopGuiRunPanel.this.m_RunThread = null;
            HadoopGuiRunPanel.this.m_StartBut.setEnabled(true);
        }

        public void run() {
            int i;
            HadoopGuiRunPanel.this.m_StartBut.setEnabled(true);
            HadoopGuiRunPanel.this.m_StopBut.setEnabled(false);
            String currentJar = System.getenv("HADOOP_HOME") + "/hadoopGui.jar";
            File cj = new File(currentJar);
            if (!cj.exists()) {
                HadoopGuiRunPanel.this.createJar();
            }
            ArrayList<String> instruction = new ArrayList<String>();
            instruction.add(this.path + "/bin/hadoop");
            instruction.add("jar");
            instruction.add(currentJar);
            instruction.add(this.uniqueFile.getName());
            instruction.add("outBB");
            DefaultListModel m_Datasets = this.m_ExpCopy.getDatasets();
            for (i = 0; i < m_Datasets.size(); ++i) {
                instruction.add("-t");
                instruction.add(m_Datasets.elementAt(i).toString());
            }
            for (i = 0; i < this.m_ExpCopy.getPropertyArrayLength(); ++i) {
                instruction.add("-classifier");
                instruction.add(Utils.toCommandLine((Object)this.m_ExpCopy.getPropertyArrayValue(i)));
            }
            instruction.add("-runs");
            instruction.add("" + this.m_ExpCopy.getRunUpper());
            instruction.add("-folds");
            instruction.add("" + ((CrossValidationResultProducer)this.m_ExpCopy.getResultProducer()).getNumFolds());
            instruction.add("-output");
            instruction.add(this.uniqueFile.getPath());
            instruction.add("-csv");
            instruction.add(((CSVResultListener)this.m_ExpCopy.getResultListener()).outputFileName());
            instruction.add("-exptype");
            String classification = "";
            classification = ((CrossValidationResultProducer)this.m_ExpCopy.getResultProducer()).getSplitEvaluator() instanceof ClassifierSplitEvaluator ? "classification" : "regression";
            instruction.add(classification);
            instruction.add("-classindex");
            instruction.add("last");
            String[] temp = instruction.toArray(new String[instruction.size()]);
            try {
                String line;
                this.p = Runtime.getRuntime().exec(temp);
                HadoopGuiRunPanel.this.m_StartBut.setEnabled(false);
                HadoopGuiRunPanel.this.m_StopBut.setEnabled(true);
                HadoopGuiRunPanel.this.statusMessage("Running");
                if (!HadoopGuiRunPanel.this.m_Log.m_LogText.getText().equals("")) {
                    HadoopGuiRunPanel.this.logMsgWithNoTime("\n --------\n");
                }
                HadoopGuiRunPanel.this.logMessage("Started");
                BufferedReader m_Stream = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
                while ((line = m_Stream.readLine()) != null) {
                    HadoopGuiRunPanel.this.logMsgWithNoTime(line);
                }
                int complete = this.p.waitFor();
                HadoopGuiRunPanel.this.m_StopBut.setEnabled(false);
                HadoopGuiRunPanel.this.m_StartBut.setEnabled(true);
                if (complete == 0) {
                    HadoopGuiRunPanel.this.statusMessage("Task Completed");
                    HadoopGuiRunPanel.this.logMessage("Finished");
                    HadoopGuiRunPanel.this.logMessage("There were 0 errors");
                } else {
                    HadoopGuiRunPanel.this.statusMessage("Task failed");
                    HadoopGuiRunPanel.this.logMessage("Interrupted");
                }
                HadoopGuiRunPanel.this.m_RunThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

