/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.listmatrix;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix2D;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListMatrix<A>
extends AbstractDenseGenericMatrix2D<A>
implements ListMatrix<A> {
    private static final long serialVersionUID = -6776628601679785451L;

    public abstract List<A> getList();

    @Override
    public final long[] getSize() {
        return new long[]{this.size(), 1L};
    }

    @Override
    public final void clear() {
        this.getList().clear();
    }

    @Override
    public boolean add(A e) {
        boolean ret = this.getList().add(e);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public void add(int index, A element) {
        this.getList().add(index, element);
        this.notifyGUIObject();
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        boolean ret = this.getList().addAll(c);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends A> c) {
        boolean ret = this.getList().addAll(index, c);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public boolean contains(Object o) {
        return this.getList().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getList().containsAll(c);
    }

    @Override
    public A get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public Iterator<A> iterator() {
        return this.getList().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    @Override
    public ListIterator<A> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<A> listIterator(int index) {
        return this.getList().listIterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = this.getList().remove(o);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public A remove(int index) {
        A a = this.getList().remove(index);
        this.notifyGUIObject();
        return a;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = this.getList().removeAll(c);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = this.getList().retainAll(c);
        this.notifyGUIObject();
        return ret;
    }

    @Override
    public A set(int index, A element) {
        A a = this.getList().set(index, element);
        this.notifyGUIObject();
        return a;
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    @Override
    public List<A> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public A getObject(long row, long column) {
        A a = this.getList().get((int)row);
        return a;
    }

    @Override
    public A getObject(int row, int column) {
        A a = this.getList().get(row);
        return a;
    }

    @Override
    public void setObject(A value, long row, long column) {
        this.getList().set((int)row, value);
        this.notifyGUIObject();
    }

    @Override
    public void setObject(A value, int row, int column) {
        this.getList().set(row, value);
        this.notifyGUIObject();
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getList().toArray(a);
    }

    @Override
    public double getAsDouble(long ... coordinates) throws MatrixException {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public void setAsDouble(double value, long ... coordinates) throws MatrixException {
        this.setAsObject(value, coordinates);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }

    @Override
    public final Matrix.StorageType getStorageType() {
        return Matrix.StorageType.LIST;
    }
}

