/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class Fill
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -3477957135967841340L;
    private Object fill = null;

    public Fill(Matrix matrix, Object value) {
        super(matrix);
        this.fill = value;
    }

    public Object getObject(long ... coordinates) {
        return this.fill;
    }

    public static Matrix calc(Matrix source, Object fill) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(source.getValueType(), source.getSize());
        for (long[] c : source.allCoordinates()) {
            ret.setAsObject(fill, c);
        }
        return ret;
    }

    public static Matrix calc(Object fill, long ... size) throws MatrixException {
        Matrix ret = null;
        ret = fill instanceof Number ? MatrixFactory.zeros(ValueType.DOUBLE, size) : (fill instanceof String ? MatrixFactory.zeros(ValueType.STRING, size) : MatrixFactory.zeros(ValueType.OBJECT, size));
        for (long[] c : ret.allCoordinates()) {
            ret.setAsObject(fill, c);
        }
        return ret;
    }
}

