/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.parallelcolt;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import java.util.HashSet;
import java.util.Iterator;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.CoordinateSetToLongWrapper;
import org.ujmp.parallelcolt.ParallelColtDenseDoubleMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelColtSparseDoubleMatrix2D
extends AbstractSparseDoubleMatrix2D
implements Wrapper<SparseDoubleMatrix2D> {
    private static final long serialVersionUID = -3223474248020842822L;
    private SparseDoubleMatrix2D matrix = null;

    public ParallelColtSparseDoubleMatrix2D(long ... size) {
        this.matrix = new SparseDoubleMatrix2D((int)size[0], (int)size[1]);
    }

    public ParallelColtSparseDoubleMatrix2D(SparseDoubleMatrix2D m) {
        this.matrix = m;
    }

    public ParallelColtSparseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getQuick((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getQuick(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.rows(), this.matrix.columns()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setQuick((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setQuick(row, column, value);
    }

    @Override
    public SparseDoubleMatrix2D getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(SparseDoubleMatrix2D object) {
        this.matrix = object;
    }

    @Override
    public Matrix inv() {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)new DenseDoubleAlgebra().inverse((DoubleMatrix2D)this.matrix));
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new AvailableCoordinateIterable();
    }

    @Override
    public final boolean contains(long ... coordinates) {
        return this.getAsDouble(coordinates) != 0.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AvailableCoordinateIterable
    implements Iterable<long[]> {
        AvailableCoordinateIterable() {
        }

        @Override
        public Iterator<long[]> iterator() {
            HashSet<Coordinates> cset = new HashSet<Coordinates>();
            long r = ParallelColtSparseDoubleMatrix2D.this.getRowCount() - 1L;
            while (r >= 0L) {
                long c = ParallelColtSparseDoubleMatrix2D.this.getColumnCount() - 1L;
                while (c >= 0L) {
                    if (ParallelColtSparseDoubleMatrix2D.this.getDouble(r, c) != 0.0) {
                        cset.add(new Coordinates(r, c));
                    }
                    --c;
                }
                --r;
            }
            return new CoordinateSetToLongWrapper(cset).iterator();
        }
    }
}

