/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.EnumWithCustomDisplay;
import adams.core.ImageMagickHelper;
import adams.core.option.AbstractOption;
import adams.flow.sink.AbstractFileWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;

public class ImageMagickWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -1264554670448330464L;
    protected ImageType m_ImageType;

    public String globalInfo() {
        return "Writes an image to disk using ImageMagick (http://www.imagemagick.org/).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)ImageType.AUTO);
    }

    public String getQuickInfo() {
        String result = this.m_ImageType.getType() + ": " + super.getQuickInfo();
        return result;
    }

    public String outputFileTipText() {
        return "The filename of the image to write.";
    }

    public void setImageType(ImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public ImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The type of image to create.";
    }

    public Class[] accepts() {
        return new Class[]{BufferedImage.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !ImageMagickHelper.isConvertAvailable()) {
            result = "'convert' is not available on PATH!";
        }
        return result;
    }

    protected ImageType determineImageType(String filename) {
        ImageType result = null;
        for (ImageType type : ImageType.values()) {
            if (!type.matches(filename)) continue;
            result = type;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Failed to determine image type for '" + filename + "'!");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        BufferedImage img = (BufferedImage)this.m_InputToken.getPayload();
        String filename = this.m_OutputFile.getAbsolutePath();
        try {
            ImageType type = this.m_ImageType == ImageType.AUTO ? this.determineImageType(filename) : this.m_ImageType;
            IMOperation op = new IMOperation();
            op.addImage();
            op.addImage(new String[]{type.getType() + ":" + filename});
            ConvertCmd cmd = new ConvertCmd();
            cmd.run((Operation)op, new Object[]{img});
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType implements EnumWithCustomDisplay<ImageType>
    {
        AUTO("AUTO", "", "Automatic"),
        AAI("AAI", "aai", "AAI Dune image"),
        AVS("AVS", "avs", "AVS X image"),
        BMP("BMP", "bmp", "Microsoft Windows bitmap"),
        CIN("CIN", "cin", "Kodak Cineon Image Format"),
        CMYK("CMYK", "cmyk", "Raw cyan, magenta, yellow, and black samples"),
        CMYKA("CMYKA", "cmyka", "Raw cyan, magenta, yellow, black, and alpha samples"),
        DCX("DCX", "dcx", "ZSoft IBM PC multi-page Paintbrush image"),
        DIB("DIB", "dib", "Microsoft Windows Device Independent Bitmap"),
        DPX("DPX", "dpx", "SMPTE Digital Moving Picture Exchange 2.0 (SMPTE 268M-2003)"),
        EPDF("EPDF", "epdf", "Encapsulated Portable Document Format"),
        EPI("EPI", "epi", "Adobe Encapsulated PostScript Interchange format"),
        EPS("EPS", "eps", "Adobe Encapsulated PostScript"),
        EPS2("EPS2", "eps", "Adobe Level II Encapsulated PostScript"),
        EPS3("EPS3", "eps", "Adobe Level III Encapsulated PostScript"),
        EPSF("EPSF", "epsf", "Adobe Encapsulated PostScript"),
        EPSI("EPSI", "epsi", "Adobe Encapsulated PostScript Interchange format"),
        EPT("EPT", "ept", "Adobe Encapsulated PostScript Interchange format with TIFF preview"),
        EXR("EXR", "exr", "High dynamic-range (HDR) file format developed by Industrial Light & Magic"),
        FAX("FAX", "fax", "Group 3 TIFF"),
        FITS("FITS", "fits", "Flexible Image Transport System"),
        FPX("FPX", "fpx", "FlashPix Format"),
        GIF("GIF", "gif", "CompuServe Graphics Interchange Format"),
        GRAY("GRAY", "gray", "Raw gray samples"),
        HDR("HDR", "hdr", "Radiance RGBE image format"),
        HRZ("HRZ", "hrz", "Slow Scane TeleVision"),
        HTML("HTML", "html", "Hypertext Markup Language with a client-side image map"),
        INFO("INFO", "info", "Format and characteristics of the image"),
        JBIG("JBIG", "jbig", "Joint Bi-level Image experts Group file interchange format"),
        JNG("JNG", "jng", "Multiple-image Network Graphics"),
        JP2("JP2", "jp2", "JPEG-2000 JP2 File Format Syntax"),
        JPC("JPC", "jpc", "JPEG-2000 Code Stream Syntax"),
        JPEG("JPEG", "jpg", "Joint Photographic Experts Group JFIF format"),
        MIFF("MIFF", "miff", "Magick image file format"),
        MONO("MONO", "mono", "Bi-level bitmap in least-significant-byte first order"),
        MNG("MNG", "mng", "Multiple-image Network Graphics"),
        M2V("M2V", "", "Motion Picture Experts Group file interchange format (version 2)"),
        MPEG("MPEG", "mpg", "Motion Picture Experts Group file interchange format (version 1)"),
        MPC("MPC", "mpc", "Magick Persistent Cache image file format"),
        MPR("MPR", "mpr", "Magick Persistent Registry"),
        MSL("MSL", "msl", "Magick Scripting Language"),
        MTV("MTV", "mtv", "MTV Raytracing image format"),
        MVG("MVG", "mvg", "Magick Vector Graphics."),
        OTB("OTB", "otb", "On-the-air Bitmap"),
        P7("P7", "p7", "Xv's Visual Schnauzer thumbnail format"),
        PALM("PALM", "palm", "Palm pixmap"),
        PAM("PAM", "pam", "Common 2-dimensional bitmap format"),
        PBM("PBM", "pbm", "Portable bitmap format (black and white)"),
        PCD("PCD", "pcd", "Photo CD"),
        PCDS("PCDS", "pcds", "Photo CD"),
        PCL("PCL", "pcl", "HP Page Control Language"),
        PCX("PCX", "pcx", "ZSoft IBM PC Paintbrush file"),
        PDB("PDB", "pdb", "Palm Database ImageViewer Format"),
        PDF("PDF", "pdf", "Portable Document Format"),
        PFM("PFM", "pfm", "Portable float map format"),
        PGM("PGM", "pgm", "Portable graymap format (gray scale)"),
        PICON("PICON", "picon", "Personal Icon"),
        PICT("PICT", "pict", "Apple Macintosh QuickDraw/PICT file"),
        PNG("PNG", "png", "Portable Network Graphics"),
        PNG8("PNG8", "png", "Portable Network Graphics"),
        PNG24("PNG24", "png", "Portable Network Graphics"),
        PNG32("PNG32", "png", "Portable Network Graphics"),
        PNM("PNM", "pnm", "Portable anymap"),
        PPM("PPM", "ppm", "Portable pixmap format (color)"),
        PS("PS", "ps", "Adobe PostScript file"),
        PS2("PS2", "ps", "Adobe Level II PostScript file"),
        PS3("PS3", "ps", "Adobe Level III PostScript file"),
        PSB("PSB", "psb", "Adobe Large Document Format"),
        PSD("PSD", "psd", "Adobe Photoshop bitmap file"),
        PTIF("PTIF", "ptif", "Pyramid encoded TIFF"),
        RGB("RGB", "rgb", "Raw red, green, and blue samples"),
        RGBA("RGBA", "rgba", "Raw red, green, blue, and alpha samples"),
        SGI("SGI", "sgi", "Irix RGB image"),
        SHTML("SHTML", "shtml", "Hypertext Markup Language client-side image map"),
        SUN("SUN", "sun", "SUN Rasterfile"),
        SVG("SVG", "svg", "Scalable Vector Graphics"),
        TGA("TGA", "tga", "Truevision Targa image"),
        TIFF("TIFF", "tiff", "Tagged Image File Format"),
        TXT("TXT", "txt", "Raw text file"),
        UIL("UIL", "uil", "X-Motif UIL table"),
        UYVY("UYVY", "uyvy", "Interleaved YUV raw image"),
        VICAR("VICAR", "vicar", "VICAR rasterfile format"),
        VIFF("VIFF", "viff", "Khoros Visualization Image File Format"),
        WBMP("WBMP", "wbmp", "Wireless bitmap"),
        WEBP("WEBP", "webp", "Weppy image format"),
        X("X", "x", "display or import an image to or from an X11 server"),
        XBM("XBM", "xbm", "X Windows system bitmap, black and white only"),
        XPM("XPM", "xpm", "X Windows system pixmap"),
        XWD("XWD", "xwd", "X Windows system window dump"),
        YCbCr("YCbCr", "ycbcr", "Raw Y, Cb, and Cr samples"),
        YCbCrA("YCbCrA", "ycbcra", "Raw Y, Cb, Cr, and alpha samples"),
        YUV("YUV", "yuv", "CCIR 601 4:1:1");

        private String m_Raw = super.toString();
        private String m_Type;
        private String m_Extension;
        private String m_Description;

        private ImageType(String type, String ext, String desc) {
            this.m_Type = type;
            this.m_Extension = ext;
            this.m_Description = desc;
        }

        public String toDisplay() {
            return this.m_Type + " - " + this.m_Description;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public String getType() {
            return this.m_Type;
        }

        public String getExtension() {
            return this.m_Extension;
        }

        public boolean matches(File file) {
            return this.matches(file.getPath());
        }

        public boolean matches(String filename) {
            return filename.toLowerCase().endsWith("." + this.m_Extension);
        }

        public ImageType parse(String s) {
            return ImageType.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((ImageType)((Object)object)).toRaw();
        }

        public static ImageType valueOf(AbstractOption option, String str) {
            ImageType result = null;
            try {
                result = ImageType.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (ImageType dt : ImageType.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

