/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.imagej.Image;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.imagej.transformer.PassThrough;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageJTransformer
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 3690378527551302472L;
    public static final String BACKUP_CURRENTIMAGES = "current images";
    protected AbstractImageJTransformer m_TransformAlgorithm;
    protected Vector<Image> m_CurrentImages;

    public String globalInfo() {
        return "Applies an ImageJ transformation to the incoming image and outputs the generated image(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformAlgorithm", (Object)new PassThrough());
    }

    protected void initialize() {
        super.initialize();
        this.m_CurrentImages = new Vector();
    }

    public void setTransformAlgorithm(AbstractImageJTransformer value) {
        this.m_TransformAlgorithm = value;
        this.reset();
    }

    public AbstractImageJTransformer getTransformAlgorithm() {
        return this.m_TransformAlgorithm;
    }

    public String transformAlgorithmTipText() {
        return "The transformer to use for transformering the image.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("transformAlgorithm");
        if (variable != null) {
            return variable;
        }
        if (this.m_TransformAlgorithm != null) {
            return this.m_TransformAlgorithm.getClass().getName();
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{Image.class};
    }

    public Class[] generates() {
        return new Class[]{Image.class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENTIMAGES);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_CURRENTIMAGES, this.m_CurrentImages);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENTIMAGES)) {
            this.m_CurrentImages = (Vector)state.get(BACKUP_CURRENTIMAGES);
            state.remove(BACKUP_CURRENTIMAGES);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        String result = null;
        try {
            Image img = (Image)this.m_InputToken.getPayload();
            this.m_CurrentImages = new Vector<Image>(Arrays.asList(this.m_TransformAlgorithm.transform(img)));
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_CurrentImages.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_CurrentImages.get(0));
        this.m_CurrentImages.remove(0);
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_CurrentImages.clear();
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.setProvenance(this.m_InputToken.getProvenance());
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

