/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class PDImageMetadata
extends IIOMetadata {
    public static final String NativeMetadataFormatName = "de_intarsys_pdf_platform_swtawt_image_1.0";
    private PDImage pdImage;

    public PDImageMetadata(PDImage paramPDImage) {
        super(false, NativeMetadataFormatName, null, null, null);
        this.pdImage = paramPDImage;
    }

    public Node getAsTree(String formatName) {
        if (!NativeMetadataFormatName.equals(formatName)) {
            throw new IllegalArgumentException();
        }
        return this.getNativeTree();
    }

    private Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(this.nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode("BitsPerComponent");
        node.setNodeValue(String.valueOf(this.pdImage.getBitsPerComponent()));
        root.appendChild(node);
        node = new IIOMetadataNode("ColorSpace");
        PDColorSpace colorSpace = this.pdImage.getColorSpace();
        String colorSpaceString = colorSpace.cosGetArray() != null ? colorSpace.cosGetArray().get(0).toString() : colorSpace.toString();
        node.setNodeValue(colorSpaceString);
        root.appendChild(node);
        node = new IIOMetadataNode("Height");
        node.setNodeValue(String.valueOf(this.pdImage.getHeight()));
        root.appendChild(node);
        node = new IIOMetadataNode("Width");
        node.setNodeValue(String.valueOf(this.pdImage.getWidth()));
        root.appendChild(node);
        return root;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }
}

