/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.Bzip2Utils;
import adams.flow.transformer.AbstractSingleCompress;
import java.io.File;

public class Bzip2
extends AbstractSingleCompress {
    private static final long serialVersionUID = 6718580828800815681L;

    public String globalInfo() {
        return "Creates a bzip2 archive from a single file. Outputs the filename of the bzip2 file generated. Optionally, the original input file can be deleted.";
    }

    public String outputTipText() {
        return "The bzip2 file to create; if pointing to a directory, then the output filename is based on the file that is being compressed and the '.bz2' extension added.";
    }

    protected String getDefaultExtension() {
        return ".bz2";
    }

    protected String compress(File inFile, File outFile) {
        return Bzip2Utils.compress(inFile, this.m_BufferSize, outFile, this.m_RemoveInputFile);
    }
}

