/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderTools {
    public static ClassLoader createClassLoader(ClassLoader parent, File baseDir, String classpath, String classpathScan, String classpathScanExclude) {
        URL[] urlArray = ClassLoaderTools.createURLs(baseDir, classpath, classpathScan, classpathScanExclude);
        URLClassLoader classLoader = new URLClassLoader(urlArray, parent);
        return classLoader;
    }

    public static void createURL(List<URL> urls, File file) {
        if (file.isFile()) {
            try {
                urls.add(new URL("file", "", file.getAbsolutePath()));
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            try {
                urls.add(new URL("file", "", String.valueOf(file.getAbsolutePath()) + "/"));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static URL[] createURLs(File baseDir, String classpath, String classpathScan, String classpathScanExclude) {
        int n;
        String[] names;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (!StringTools.isEmpty(classpath)) {
            String[] stringArray = names = classpath.split(";");
            n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(name);
                if (!file.isAbsolute()) {
                    file = new File(baseDir, name);
                }
                ClassLoaderTools.createURL(urls, file);
                ++n2;
            }
        }
        if (!StringTools.isEmpty(classpathScan)) {
            names = classpathScan.split(";");
            List<Object> exclude = StringTools.isEmpty(classpathScanExclude) ? new ArrayList() : Arrays.asList(classpathScanExclude.split(";"));
            String[] stringArray = names;
            int n3 = names.length;
            n = 0;
            while (n < n3) {
                String name = stringArray[n];
                File file = new File(name);
                if (!file.isAbsolute()) {
                    file = new File(baseDir, name);
                }
                ClassLoaderTools.createURLScanJar(urls, file, exclude);
                ++n;
            }
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        return urlArray;
    }

    public static void createURLScanJar(List<URL> result, File directory, final List<String> exclude) {
        File[] jarFiles = directory.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isFile() && path.canRead() && path.getName().toLowerCase().endsWith(".jar") && !exclude.contains(path.getName());
            }
        });
        if (jarFiles != null) {
            File[] fileArray = jarFiles;
            int n = jarFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    result.add(new URL("file", "", file.getAbsolutePath()));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }
}

