/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;
import java.util.Random;
import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.core.Utils;

public class Distribution
implements Serializable {
    private static final long serialVersionUID = 6791890020030731250L;
    protected Alphabet alphabet;
    protected double[] probs;
    protected boolean useLogSpace;

    public Distribution(Alphabet alpha, boolean useLogSpace) {
        this.alphabet = alpha;
        this.probs = new double[this.alphabet.alphabetSize()];
        this.useLogSpace = useLogSpace;
        for (int i = 0; i < this.probs.length; ++i) {
            this.probs[i] = !useLogSpace ? 0.0 : Double.NEGATIVE_INFINITY;
        }
    }

    public double getProb(String s) throws IllegalSymbolException {
        return this.probs[this.alphabet.indexOfAlphabetSymbol(s)];
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.alphabet.toString() + "\n");
        for (int i = 0; i < this.probs.length; ++i) {
            output.append(this.probs[i] + " ");
        }
        output.append("\n");
        return output.toString();
    }

    public boolean isUseLogSpace() {
        return this.useLogSpace;
    }

    public String getSymbol(int seed) {
        int index;
        Random rand = new Random(seed);
        double actualProb = rand.nextDouble();
        double sum = 0.0;
        if (!this.useLogSpace) {
            for (index = 0; index < this.probs.length; ++index) {
                if (!((sum += this.probs[index]) > actualProb)) continue;
                return this.alphabet.getSymbolAtIndex(index);
            }
        } else {
            double[] realprobs = new double[this.probs.length];
            for (int i = 0; i < this.probs.length; ++i) {
                realprobs[i] = this.probs[i] == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(this.probs[i]);
            }
            Utils.normalize((double[])realprobs);
            while (index < realprobs.length) {
                if ((sum += realprobs[index]) > actualProb) {
                    return this.alphabet.getSymbolAtIndex(index);
                }
                ++index;
            }
        }
        return this.alphabet.getSymbolAtIndex(index);
    }
}

