/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.data.fit.InitialParameterGuesser;
import adams.data.fit.NonlinearFunction;
import adams.data.statistics.Percentile;
import adams.data.statistics.StatUtils;

public class NormalDistribution
extends NonlinearFunction
implements InitialParameterGuesser {
    private static final long serialVersionUID = 1670768051070643034L;

    @Override
    public String globalInfo() {
        return "Fits the normal distribution to the data.\n\nFor derivatives, see:\nhttp://www.numberempire.com/derivatives.php";
    }

    @Override
    public double[] calcDerivatives(double x, double[] a) {
        double[] result = new double[2];
        if (a.length != result.length) {
            throw new IllegalStateException("Number of coefficients differs from number of partial derivatives: " + a.length + " != " + result.length);
        }
        double m = a[0];
        double s = a[1];
        result[0] = (x - m) * Math.exp(-((x * x - 2.0 * m * x + m * m) / (2.0 * s * s))) / (Math.sqrt(2.0) * Math.sqrt(Math.PI) * s * s * Math.abs(s));
        result[1] = (Math.sqrt(2.0) * x * x - Math.pow(2.0, 1.0) * m * x - Math.sqrt(2.0) * s * s + Math.sqrt(2.0) * m * m) * Math.exp(-((x * x - 2.0 * m * x + m * m) / (2.0 * s * s))) / (2.0 * Math.sqrt(Math.PI) * s * s * s * Math.abs(s));
        return result;
    }

    @Override
    public double calcY(double x, double[] a) {
        double m = a[0];
        double s = a[1];
        return 1.0 / Math.sqrt(Math.PI * 2 * s * s) * Math.exp(-(x - m) * (x - m) / (2.0 * s * s));
    }

    @Override
    public double[] guess(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Array lengths of x and y differ: " + x.length + " != " + y.length);
        }
        double[] result = new double[2];
        result[0] = StatUtils.median(y);
        Percentile<Double> perc = new Percentile<Double>();
        for (int i = 0; i < y.length; ++i) {
            perc.add(y[i]);
        }
        double perc25 = (Double)perc.getPercentile(0.25);
        double perc75 = (Double)perc.getPercentile(0.75);
        result[1] = (perc75 - perc25) / 1.349;
        return result;
    }
}

