/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ClassLocator;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Unknown;
import java.io.Serializable;
import java.util.HashSet;

public class Compatibility
implements Serializable {
    private static final long serialVersionUID = -8139225807701691972L;
    protected boolean m_Strict;

    public void setStrict(boolean value) {
        this.m_Strict = value;
    }

    public boolean isStrict() {
        return this.m_Strict;
    }

    public boolean isCompatible(Class output, Class input) {
        if (!(this.m_Strict || input != Unknown.class && output != Unknown.class)) {
            return true;
        }
        if (output.isArray() && input.isArray()) {
            return this.isCompatible(output.getComponentType(), input.getComponentType());
        }
        if (output.isArray() != input.isArray()) {
            return false;
        }
        if (input == Object.class && !this.m_Strict) {
            return true;
        }
        if (output == input) {
            return true;
        }
        if (ClassLocator.isSubclass(input, output)) {
            return true;
        }
        return ClassLocator.hasInterface(input, output);
    }

    public boolean isCompatible(Class[] outCls, Class[] inCls) {
        boolean result = false;
        for (int i = 0; i < outCls.length; ++i) {
            for (int n = 0; n < inCls.length; ++n) {
                if (!this.isCompatible(outCls[i], inCls[n])) continue;
                result = true;
                break;
            }
            if (result) break;
        }
        return result;
    }

    public boolean isCompatible(OutputProducer output, InputConsumer input) {
        return this.isCompatible(output.generates(), input.accepts());
    }

    public HashSet<Class> getCompatibleClasses(OutputProducer output, InputConsumer input) {
        HashSet<Class> result = new HashSet<Class>();
        Class[] outCls = output.generates();
        Class[] inCls = input.accepts();
        block0: for (int i = 0; i < outCls.length; ++i) {
            for (int n = 0; n < inCls.length; ++n) {
                if (!this.isCompatible(outCls[i], inCls[n])) continue;
                result.add(outCls[i]);
                continue block0;
            }
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + ": strict=" + this.isStrict();
    }
}

