/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;

public class SequenceToArray
extends AbstractTransformer {
    private static final long serialVersionUID = 8411367398473311627L;
    public static final String BACKUP_ELEMENTS = "elements";
    protected Vector m_Elements;
    protected int m_ArrayLength;
    protected String m_ArrayClass;

    @Override
    public String globalInfo() {
        return "Turns a sequence of tokens into arrays with a specified length.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("length", "arrayLength", 1);
        this.m_OptionManager.add("array-class", "arrayClass", "");
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("arrayLength");
        String result = variable != null ? "Length: " + variable : "Length: " + this.m_ArrayLength;
        result = result + ", Class: ";
        variable = this.getOptionManager().getVariableForProperty("arrayClass");
        result = variable != null ? result + variable : (this.m_ArrayClass.length() != 0 ? result + this.m_ArrayClass : result + "-from 1st element-");
        return result;
    }

    public void setArrayLength(int value) {
        if (value < 1) {
            this.getSystemErr().println("Arrays must have a length of at least 1, provided: " + value + "!");
        } else {
            this.m_ArrayLength = value;
            this.reset();
        }
    }

    public int getArrayLength() {
        return this.m_ArrayLength;
    }

    public String arrayLengthTipText() {
        return "The length of the arrays.";
    }

    public void setArrayClass(String value) {
        this.m_ArrayClass = value;
        this.reset();
    }

    public String getArrayClass() {
        return this.m_ArrayClass;
    }

    public String arrayClassTipText() {
        return "The class to use for the array; if none is specified, the class of the first element is used.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ELEMENTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_ELEMENTS, this.m_Elements);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ELEMENTS)) {
            this.m_Elements = (Vector)state.get(BACKUP_ELEMENTS);
            state.remove(BACKUP_ELEMENTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Elements = new Vector();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_Elements.add(this.m_InputToken.getPayload());
            this.debug("Buffered elements: " + this.m_Elements.size());
            if (this.m_Elements.size() == this.m_ArrayLength) {
                Object array = this.m_ArrayClass.length() == 0 ? Array.newInstance(this.m_Elements.firstElement().getClass(), this.m_ArrayLength) : Array.newInstance(Class.forName(this.m_ArrayClass), this.m_ArrayLength);
                this.debug("Array type: " + array.getClass().getComponentType());
                for (int i = 0; i < this.m_ArrayLength; ++i) {
                    Array.set(array, i, this.m_Elements.get(i));
                }
                this.m_OutputToken = new Token(array);
                this.m_Elements.clear();
                this.debug("Array generated");
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

