/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.flow.transformer.AbstractStringOperation;

public class StringMatcher
extends AbstractStringOperation {
    private static final long serialVersionUID = 9030574317512531337L;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Lets string tokens only pass if they match the regular expression. Matching sense can be inverted as well.\nSpecial characters like \\n \\r \\t and \\ need to be escaped properly. The input is expected to be escaped, i.e., the string \"\\t\" will get turned into the character '\\t'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("regExp");
        if (variable != null) {
            return (this.m_Invert ? "! " : "") + variable;
        }
        if (this.m_RegExp != null && !this.m_RegExp.isEmpty()) {
            return (this.m_Invert ? "! " : "") + this.m_RegExp;
        }
        return null;
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the strings.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    @Override
    protected String process(String s) {
        boolean pass = this.m_Invert ? !this.m_RegExp.isMatch(s) : this.m_RegExp.isMatch(s);
        if (this.isDebugOn()) {
            this.debug("'" + s + "' " + (this.m_Invert ? "doesn't match" : "matches") + " '" + this.m_RegExp + "': " + pass);
        }
        if (pass) {
            return s;
        }
        return null;
    }
}

