/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Memory;
import adams.core.Properties;
import adams.env.Environment;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MemoryUsagePanel
extends BasePanel {
    private static final long serialVersionUID = -4812319791687471721L;
    public static final String FILENAME = "MemoryUsage.props";
    protected static Properties m_Properties;
    protected Vector<Double> m_History;
    protected Memory m_Memory;
    protected MemoryMonitor m_Monitor;
    protected JButton m_ButtonGC;
    protected Vector<Double> m_Percentages;
    protected Hashtable<Double, Color> m_Colors;
    protected Color m_DefaultColor;
    protected Color m_BackgroundColor;
    protected Point m_FrameLocation;

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = MemoryUsagePanel.getProperties();
        this.m_Memory = Memory.getSingleton();
        this.m_History = new Vector();
        this.m_Percentages = new Vector();
        this.m_Colors = new Hashtable();
        this.m_BackgroundColor = props.getColor("BackgroundColor", Color.WHITE);
        this.m_DefaultColor = props.getColor("DefaultColor", Color.GREEN);
        String[] percs = props.getProperty("Percentages", "70,80,90").split(",");
        for (int i = 0; i < percs.length; ++i) {
            if (props.hasKey(percs[i])) {
                double perc;
                try {
                    perc = Double.parseDouble(percs[i]);
                }
                catch (Exception e) {
                    System.err.println("MemoryUsagePanel: cannot parse percentage '" + percs[i] + "' - ignored!");
                    continue;
                }
                Color color = props.getColor(percs[i], null);
                if (color == null) continue;
                this.m_Percentages.add(perc);
                this.m_Colors.put(perc, color);
                continue;
            }
            System.err.println("MemoryUsagePanel: cannot find color for percentage '" + percs[i] + "' - ignored!");
        }
        Collections.sort(this.m_Percentages);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "East");
        this.m_ButtonGC = new JButton("GC");
        this.m_ButtonGC.setToolTipText("Runs the garbage collector.");
        this.m_ButtonGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.gc();
            }
        });
        panel.add((Component)this.m_ButtonGC, "North");
        int height = props.getInteger("Height", (int)this.m_ButtonGC.getPreferredSize().getHeight());
        int width = props.getInteger("Width", 400);
        this.setPreferredSize(new Dimension(width, height));
        int top = props.getInteger("Top", 0);
        int left = props.getInteger("Left", 0);
        this.m_FrameLocation = new Point(left, top);
        int interval = props.getInteger("Interval", 1000);
        this.m_Monitor = new MemoryMonitor();
        this.m_Monitor.setInterval(interval);
        this.m_Monitor.setPriority(10);
        this.m_Monitor.start();
    }

    public boolean isMonitoring() {
        return this.m_Monitor.isMonitoring();
    }

    public void stopMonitoring() {
        this.m_Monitor.stopMonitoring();
    }

    public Point getFrameLocation() {
        return this.m_FrameLocation;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.m_BackgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double scale = (double)this.getHeight() / 100.0;
        for (int i = 0; i < this.m_History.size(); ++i) {
            double perc = this.m_History.get(i);
            Color color = this.m_DefaultColor;
            for (int n = this.m_Percentages.size() - 1; n >= 0; --n) {
                if (!(perc >= this.m_Percentages.get(n))) continue;
                color = this.m_Colors.get(this.m_Percentages.get(n));
                break;
            }
            g.setColor(color);
            int len = (int)Math.round(perc * scale);
            g.drawLine(i, this.getHeight() - 1, i, this.getHeight() - len);
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("memory usage");
        }
        return m_Properties;
    }

    protected class MemoryMonitor
    extends Thread {
        protected int m_Interval;
        protected boolean m_Monitoring;

        public MemoryMonitor() {
            this.setInterval(MemoryUsagePanel.getProperties().getInteger("Interval", 1000));
        }

        public int getInterval() {
            return this.m_Interval;
        }

        public void setInterval(int value) {
            this.m_Interval = value;
        }

        public boolean isMonitoring() {
            return this.m_Monitoring;
        }

        public void stopMonitoring() {
            this.m_Monitoring = false;
        }

        @Override
        public void run() {
            this.m_Monitoring = true;
            while (this.m_Monitoring) {
                try {
                    Thread.sleep(this.m_Interval);
                    if (!this.m_Monitoring) continue;
                    Runnable doUpdate = new Runnable(){

                        @Override
                        public void run() {
                            MemoryMonitor.this.update();
                        }
                    };
                    SwingUtilities.invokeLater(doUpdate);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        protected void update() {
            double perc = (double)MemoryUsagePanel.this.m_Memory.getCurrent() / (double)MemoryUsagePanel.this.m_Memory.getMax();
            perc = Math.round(perc * 1000.0) / 10L;
            MemoryUsagePanel.this.setToolTipText("" + perc + "% used");
            MemoryUsagePanel.this.m_History.insertElementAt(perc, 0);
            Dimension size = MemoryUsagePanel.this.getSize();
            while ((double)MemoryUsagePanel.this.m_History.size() > size.getWidth()) {
                MemoryUsagePanel.this.m_History.remove(MemoryUsagePanel.this.m_History.size() - 1);
            }
            MemoryUsagePanel.this.repaint();
        }
    }
}

