/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.io.PlaceholderDirectory;
import adams.core.option.AbstractOption;
import adams.gui.chooser.BaseDirectoryChooser;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;

public class PlaceholderDirectoryEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected BaseDirectoryChooser m_DirChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((PlaceholderDirectory)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new PlaceholderDirectory(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return PlaceholderDirectoryEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return PlaceholderDirectoryEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        File f = (File)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new adams.core.io.PlaceholderDirectory(\"" + f.getName() + "\")";
    }

    @Override
    protected JComponent createCustomEditor() {
        PlaceholderDirectory currentDir = (PlaceholderDirectory)this.getValue();
        this.m_DirChooser = currentDir != null ? new BaseDirectoryChooser() : new BaseDirectoryChooser(new File(System.getProperty("user.dir")));
        this.m_DirChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmdString = e.getActionCommand();
                if (cmdString.equals("ApproveSelection")) {
                    PlaceholderDirectory newVal = new PlaceholderDirectory(PlaceholderDirectoryEditor.this.m_DirChooser.getSelectedFile().getAbsolutePath());
                    PlaceholderDirectoryEditor.this.setValue(newVal);
                }
                PlaceholderDirectoryEditor.this.closeDialog();
            }
        });
        return this.m_DirChooser;
    }

    @Override
    protected void initForDisplay() {
        PlaceholderDirectory currentFile = (PlaceholderDirectory)this.getValue();
        if (currentFile != null) {
            this.m_DirChooser.setSelectedFile(currentFile);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        File f = (File)this.getValue();
        String val = "No directory";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

