/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.FieldType;
import adams.gui.core.ComparableTableModel;
import adams.gui.core.SearchParameters;
import adams.gui.selection.AbstractFieldCacheItem;
import adams.gui.selection.AbstractTableBasedSelectionPanel;
import java.util.Hashtable;
import java.util.Vector;

public class FieldCacheTableModel
extends AbstractTableBasedSelectionPanel.AbstractSelectionTableModel<AbstractField>
implements ComparableTableModel {
    private static final long serialVersionUID = 7823434093663335692L;
    protected String m_DatabaseURL;
    protected Hashtable<FieldType, Vector<AbstractField>> m_Fields = new Hashtable();
    protected FieldType m_FieldType;
    protected DataType m_DataType;

    public FieldCacheTableModel(AbstractFieldCacheItem cache, FieldType fieldType, DataType dataType) {
        if (cache != null) {
            this.m_DatabaseURL = cache.getDatabaseConnection().getURL();
            if (dataType == null) {
                for (FieldType type : FieldType.values()) {
                    this.m_Fields.put(type, (Vector)cache.getValues(type).clone());
                }
            } else {
                for (FieldType type : FieldType.values()) {
                    this.m_Fields.put(type, (Vector)cache.getValues(type, dataType).clone());
                }
            }
        } else {
            this.m_DatabaseURL = "-none-";
            for (FieldType type : FieldType.values()) {
                this.m_Fields.put(type, new Vector());
            }
        }
        this.m_FieldType = fieldType;
        this.m_DataType = dataType;
    }

    public String getDatabaseURL() {
        return this.m_DatabaseURL;
    }

    @Override
    public int getRowCount() {
        return this.m_Fields.get((Object)this.m_FieldType).size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Field";
        }
        throw new IllegalArgumentException("Column " + column + " is invalid!");
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        throw new IllegalArgumentException("Column " + columnIndex + " is invalid!");
    }

    @Override
    public Class getComparisonColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return AbstractField.class;
        }
        throw new IllegalArgumentException("Column " + columnIndex + " is invalid!");
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.m_Fields.get((Object)this.m_FieldType).get(row).toDisplayString();
        }
        throw new IllegalArgumentException("Column " + column + " is invalid!");
    }

    @Override
    public Object getComparisonValueAt(int row, int column) {
        if (column == 0) {
            return this.m_Fields.get((Object)this.m_FieldType).get(row);
        }
        throw new IllegalArgumentException("Column " + column + " is invalid!");
    }

    @Override
    public AbstractField getItemAt(int row) {
        if (row >= 0 && row < this.m_Fields.get((Object)this.m_FieldType).size()) {
            return this.m_Fields.get((Object)this.m_FieldType).get(row);
        }
        return null;
    }

    @Override
    public int indexOf(AbstractField t) {
        int result = -1;
        Vector<AbstractField> fields = this.m_Fields.get((Object)this.m_FieldType);
        for (int i = 0; i < fields.size(); ++i) {
            if (!t.equals(fields.get(i))) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public boolean isSearchMatch(SearchParameters params, int row) {
        return params.matches(this.m_Fields.get((Object)this.m_FieldType).get(row).toString());
    }

    public void setFieldType(FieldType value) {
        if (this.m_FieldType != value) {
            this.m_FieldType = value;
            this.fireTableDataChanged();
        }
    }

    public FieldType getFieldType() {
        return this.m_FieldType;
    }

    public void setDataType(DataType value) {
        if (this.m_DataType != value) {
            this.m_DataType = value;
            this.fireTableDataChanged();
        }
    }

    public DataType getDataType() {
        return this.m_DataType;
    }
}

