/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractAxisModel;

public class AbsoluteAxisModel
extends AbstractAxisModel {
    private static final long serialVersionUID = 6882846237550109166L;

    @Override
    public boolean canHandle(double min, double max) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Absolute";
    }

    @Override
    public String valueToDisplay(double value) {
        return this.getActualFormatter().format(value);
    }

    @Override
    public double displayToValue(String display) {
        return this.getActualFormatter().parse(display);
    }

    @Override
    public int valueToPos(double value) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        int result = (int)Math.round((value - this.m_ActualMinimum) / (this.m_ActualMaximum - this.m_ActualMinimum) * (double)size);
        return result;
    }

    @Override
    public double posToValue(int pos) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        double result = (double)pos / (double)size * (this.m_ActualMaximum - this.m_ActualMinimum) + this.m_ActualMinimum;
        return result;
    }
}

