/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.parser.AbstractExpressionEvaluator;
import adams.parser.GrammarSupplier;
import adams.parser.templatesuggestion.Parser;
import adams.parser.templatesuggestion.Scanner;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class ActorTemplateSuggestion
extends AbstractExpressionEvaluator<AbstractActorTemplate>
implements GrammarSupplier {
    private static final long serialVersionUID = -2060968616326323959L;
    protected AbstractActor m_Parent;
    protected int m_Position;
    protected AbstractActor[] m_Actors;

    @Override
    public String globalInfo() {
        return "Evaluates rules for suggesting actor templates.\n\nIt uses the following grammar:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return " expr_list ::= expr_list expr_part | expr_part ;\n expr_part ::= boolexpr : <classname | \"classname+options\">;\n\n boolexpr ::=    boolean\n               | boolexpr AND boolexpr\n               | TRUE\n               | FALSE\n               | NOT boolexpr\n               | ISFIRST\n               | ISLAST\n               | PARENT IS <classname>\n               | BEFORE STANDALONE\n               | AFTER STANDALONE\n               | BEFORE SOURCE\n               | AFTER SOURCE\n               | BEFORE TRANSFORMER\n               | AFTER TRANSFORMER\n               | BEFORE SINK\n               | AFTER SINK\n               | BEFORE <classname>\n               | AFTER <classname>\n               ;\n";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("parent", "parent", new Flow());
        this.m_OptionManager.add("position", "position", 0, 0, null);
        this.m_OptionManager.add("actor", "actors", new AbstractActor[0]);
    }

    @Override
    protected String getDefaultExpression() {
        return "TRUE: adams.flow.template.UpdateVariable";
    }

    @Override
    public String expressionTipText() {
        return "The rule for determining the actor template to propose (result is null if rul does not apply).";
    }

    public void setParent(AbstractActor value) {
        this.m_Parent = value;
    }

    public AbstractActor getParent() {
        return this.m_Parent;
    }

    public String parentTipText() {
        return "The parent actor to use.";
    }

    public void setPosition(int value) {
        this.m_Position = value;
    }

    public int getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position to add the proposed actor at.";
    }

    public void setActors(AbstractActor[] value) {
        this.m_Actors = value;
    }

    public AbstractActor[] getActors() {
        return this.m_Actors;
    }

    public String actorsTipText() {
        return "The actors to insert the proposed actor in.";
    }

    @Override
    public AbstractActorTemplate evaluate() throws Exception {
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(this.m_Expression.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setParent(this.getParent());
        parser.setPosition(this.getPosition());
        parser.setActors(this.getActors());
        parser.parse();
        return parser.getResult();
    }

    public static AbstractActorTemplate evaluate(String expr, AbstractActor parent, int position, AbstractActor[] actors) throws Exception {
        AbstractActorTemplate[] result = ActorTemplateSuggestion.evaluate(new String[]{expr}, parent, position, actors);
        return result[0];
    }

    public static AbstractActorTemplate[] evaluate(String[] expr, AbstractActor parent, int position, AbstractActor[] actors) throws Exception {
        ActorTemplateSuggestion suggestion = new ActorTemplateSuggestion();
        suggestion.setParent(parent);
        suggestion.setPosition(position);
        suggestion.setActors(actors);
        ArrayList<AbstractActorTemplate> result = new ArrayList<AbstractActorTemplate>();
        for (int i = 0; i < expr.length; ++i) {
            suggestion.setExpression(expr[i]);
            AbstractActorTemplate template = suggestion.evaluate();
            if (template == null || result.contains(template)) continue;
            result.add(template);
        }
        return result.toArray(new AbstractActorTemplate[result.size()]);
    }
}

