/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.IFont;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.SymbolEncoding;
import de.intarsys.pdf.encoding.WinAnsiEncoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.platform.cwt.font.CommonFontConverter;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.tools.locator.ILocator;
import java.awt.geom.Rectangle2D;

public abstract class FontConverterPlatform2Pdf
extends CommonFontConverter {
    private PDFont pdFont;
    private IPlatformFont pfFont;

    public FontConverterPlatform2Pdf(IFont font) {
        super(font);
    }

    protected abstract PDFont basicCreatePdFont() throws FontFactoryException;

    protected IPlatformFont basicCreatePfFont() throws FontFactoryException {
        try {
            return PlatformFontFactory.get().createPlatformFont(this.pdFont);
        }
        catch (PlatformFontException e) {
            throw new FontFactoryException((Throwable)e);
        }
    }

    protected void createPdFont() throws FontFactoryException {
        this.pdFont = this.basicCreatePdFont();
        this.pdFont.setBaseFont(this.getCwtFont().getFontNamePostScript());
        PlatformFontTools.setCWTFont(this.pdFont, this.getCwtFont());
        this.pdFont.setLookupFontName(this.getCwtFont().getFontName());
        this.pdFont.setLookupFontFamilyName(this.getCwtFont().getFontFamilyName());
        this.pdFont.setLookupFontStyle(PDFontStyle.getFontStyle((String)this.getCwtFont().getFontStyle().getId()));
        PDFontDescriptorEmbedded result = (PDFontDescriptorEmbedded)PDFontDescriptorEmbedded.META.createNew();
        this.pdFont.setFontDescriptor((PDFontDescriptor)result);
        this.pfFont = this.basicCreatePfFont();
        this.fillPdFont();
        if (this.isEmbed()) {
            this.embedFontFile(this.getCwtFont().getFontProgram().getLocator());
        }
    }

    protected void embedFontFile(ILocator locator) throws FontFactoryException {
    }

    protected void fillFontDescriptor() throws FontFactoryException {
        PDFontDescriptorEmbedded result = (PDFontDescriptorEmbedded)this.getPdFont().getFontDescriptor();
        result.setAscent(this.pfFont.getAscent());
        result.setDescent(this.pfFont.getDescent());
        result.setCapHeight(this.pfFont.getHeight());
        Rectangle2D rect = this.pfFont.getBBox();
        CDSRectangle cdsRect = new CDSRectangle(rect);
        result.setFontBB(cdsRect);
        result.setFontName(this.pdFont.getBaseFont().stringValue());
        result.getFlags().setSymbolic(this.pfFont.isSymbolFont());
        result.getFlags().setItalic(this.pfFont.isItalicStyle());
        result.getFlags().setForceBold(this.pfFont.isBoldStyle());
        result.getFlags().setFixedPitch(this.pfFont.isMonospaced());
    }

    protected void fillPdFont() throws FontFactoryException {
        if (this.pfFont.isSymbolFont()) {
            this.pdFont.setEncoding((Encoding)SymbolEncoding.UNIQUE);
        } else {
            this.pdFont.setEncoding((Encoding)WinAnsiEncoding.UNIQUE);
        }
        this.fillFontDescriptor();
        this.fillWidths();
    }

    protected void fillWidths() throws FontFactoryException {
        int last = 255;
        int first = 0;
        try {
            COSArray widths = COSArray.create((int)(last - first + 1));
            int i = first;
            while (i <= last) {
                PDGlyphs pdglyphs = this.pdFont.getGlyphsEncoded(i);
                IPlatformGlyphs pfglyphs = this.pfFont.createPlatformGlyphs(pdglyphs);
                widths.add((COSObject)COSInteger.create((int)pfglyphs.getWidth()));
                ++i;
            }
            this.pdFont.cosSetField(PDFont.DK_FirstChar, (COSObject)COSInteger.create((int)first));
            this.pdFont.cosSetField(PDFont.DK_LastChar, (COSObject)COSInteger.create((int)last));
            this.pdFont.cosSetField(PDFont.DK_Widths, (COSObject)widths);
        }
        catch (PlatformFontException e) {
            throw new FontFactoryException((Throwable)e);
        }
    }

    public PDFont getPdFont() throws FontFactoryException {
        if (this.pdFont == null) {
            this.createPdFont();
        }
        return this.pdFont;
    }
}

