/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class ReplaceMissingValuesWithZero
extends Filter
implements UnsupervisedFilter,
StreamableFilter {
    private static final long serialVersionUID = 5990095244439198836L;

    public String globalInfo() {
        return "Replaces all missing values with 0.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    private void convertInstance(Instance instance) {
        double[] vals = new double[instance.numAttributes()];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            vals[i] = instance.isMissing(i) ? 0.0 : instance.value(i);
        }
        Object inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues((Instance)inst, false, instance.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        this.push((Instance)inst);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 534 $");
    }

    public static void main(String[] argv) {
        ReplaceMissingValuesWithZero.runFilter((Filter)new ReplaceMissingValuesWithZero(), (String[])argv);
    }
}

