/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.statements;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.engine.DataModel;
import org.jopendocument.dom.template.engine.Material;
import org.jopendocument.dom.template.engine.Parsed;
import org.jopendocument.dom.template.engine.Processor;
import org.jopendocument.dom.template.statements.Statement;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.cache.CacheResult;
import org.jopendocument.util.cache.ICache;

public class Include
extends Statement {
    private static final String PREFIX = "[IOD";
    private final ICache<File, ODSingleXMLDocument, File> cache = new ICache(180);
    private final ICache<String, Parsed<ODSingleXMLDocument>, File> parsedCache = new ICache(180);

    public Include() {
        super("include");
    }

    @Override
    public boolean matches(Element element) {
        if (!element.getQualifiedName().equals("text:a")) {
            return false;
        }
        String string = Include.getName(element);
        return string != null && string.startsWith(PREFIX);
    }

    private static String getName(Element element) {
        return element.getAttributeValue("name", element.getNamespace("office"));
    }

    @Override
    public void prepare(Element element) {
        String string = element.getAttributeValue("href", element.getNamespace("xlink"));
        int n = string.indexOf(35);
        String string2 = string.substring(0, n);
        int n2 = string.lastIndexOf(124);
        int n3 = n2 < 0 ? string.lastIndexOf("%7C") : n2;
        String string3 = string.substring(n + 1, n3);
        String string4 = Include.getName(element);
        String string5 = string4.substring(PREFIX.length(), string4.lastIndexOf(93)).trim();
        Element element2 = string5.length() > 0 ? new Element("param").setText(string5) : null;
        element.removeContent();
        element.getAttributes().clear();
        element.setName(this.getName());
        element.setNamespace(stmtNS);
        element.setAttribute("path", string2);
        element.setAttribute("section", string3);
        if (element2 != null) {
            element.addContent(element2);
        }
    }

    @Override
    public void execute(Processor<?> processor, Element element, DataModel dataModel) throws TemplateException {
        if (processor.getMaterial().getBase() == null) {
            throw new TemplateException("no base file for " + processor.getMaterial());
        }
        try {
            String string = element.getAttributeValue("path");
            File file = new File(processor.getMaterial().getBase(), string).getCanonicalFile();
            Parsed<ODSingleXMLDocument> parsed = this.getParsed(file, element.getAttributeValue("section"), processor.getParsed());
            ODSingleXMLDocument oDSingleXMLDocument = parsed.execute(this.getModel(dataModel, element));
            Object obj = processor.getMaterial().getWhole();
            ODSingleXMLDocument oDSingleXMLDocument2 = obj instanceof ODPackage ? (ODSingleXMLDocument)((ODPackage)obj).getContent() : (ODSingleXMLDocument)obj;
            oDSingleXMLDocument2.replace(Include.getAncestorByName(element, "p"), oDSingleXMLDocument);
        }
        catch (IOException iOException) {
            throw ExceptionUtils.createExn(TemplateException.class, "", iOException);
        }
        catch (JDOMException jDOMException) {
            throw ExceptionUtils.createExn(TemplateException.class, "", jDOMException);
        }
        element.detach();
    }

    private Parsed<ODSingleXMLDocument> getParsed(File file, String string, Parsed<?> parsed) throws JDOMException, IOException, TemplateException {
        Parsed<ODSingleXMLDocument> parsed2;
        String string2 = file.getPath() + "#" + string;
        CacheResult<Parsed<ODSingleXMLDocument>> cacheResult = this.parsedCache.check(string2);
        if (cacheResult.getState() == CacheResult.State.NOT_IN_CACHE) {
            parsed2 = this.createParsed(file, string, parsed);
            this.parsedCache.put(string2, parsed2, Collections.emptySet());
        } else {
            parsed2 = cacheResult.getRes();
        }
        return parsed2;
    }

    private Parsed<ODSingleXMLDocument> createParsed(File file, String string, Parsed<?> parsed) throws JDOMException, IOException, TemplateException {
        ODSingleXMLDocument oDSingleXMLDocument = this.getXMLDocument(file).clone();
        XPath xPath = oDSingleXMLDocument.getXPath("//text:section[@text:name = '" + string + "']");
        Element element = (Element)xPath.selectSingleNode(oDSingleXMLDocument.getDocument());
        oDSingleXMLDocument.getBody().setContent(element.detach());
        Material<ODSingleXMLDocument> material = Material.from(oDSingleXMLDocument);
        material.setBase(file);
        return new Parsed<ODSingleXMLDocument>(material, parsed);
    }

    private ODSingleXMLDocument getXMLDocument(File file) throws JDOMException, IOException {
        ODSingleXMLDocument oDSingleXMLDocument;
        CacheResult<ODSingleXMLDocument> cacheResult = this.cache.check(file);
        if (cacheResult.getState() == CacheResult.State.NOT_IN_CACHE) {
            oDSingleXMLDocument = ODSingleXMLDocument.createFromFile(file);
            this.cache.put(file, oDSingleXMLDocument, Collections.emptySet());
        } else {
            oDSingleXMLDocument = cacheResult.getRes();
        }
        return oDSingleXMLDocument;
    }

    private DataModel getModel(DataModel dataModel, Element element) throws TemplateException {
        DataModel dataModel2;
        Element element2 = element.getChild("param");
        if (element2 != null) {
            dataModel2 = dataModel.copy();
            dataModel2.eval(element2.getText());
        } else {
            dataModel2 = dataModel;
        }
        return dataModel2;
    }
}

