/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.core.Instances;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.ClassValuePicker;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;

public class ClassValuePickerCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerClosingListener,
CustomizerCloseRequester {
    private static final long serialVersionUID = 8213423053861600469L;
    private boolean m_displayValNames = false;
    private ClassValuePicker m_classValuePicker;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private JComboBox m_ClassValueCombo = new JComboBox();
    private JPanel m_holderP = new JPanel();
    private JLabel m_messageLabel = new JLabel("No customization possible at present.");
    private BeanCustomizer.ModifyListener m_modifyListener;
    private boolean m_modified = false;
    private Window m_parent;
    private String m_backup;
    private boolean m_textBoxEntryMode = false;
    private JTextField m_valueTextBox;

    public ClassValuePickerCustomizer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("ClassValuePickerCustomizer"), "North");
        this.m_holderP.setLayout(new BorderLayout());
        this.m_holderP.setBorder(BorderFactory.createTitledBorder("Choose class value"));
        this.m_holderP.add((Component)this.m_ClassValueCombo, "Center");
        this.m_ClassValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassValuePickerCustomizer.this.m_classValuePicker != null) {
                    ClassValuePickerCustomizer.this.m_classValuePicker.setClassValue(ClassValuePickerCustomizer.this.m_ClassValueCombo.getSelectedItem().toString());
                    ClassValuePickerCustomizer.this.m_modified = true;
                }
            }
        });
        this.add((Component)this.m_messageLabel, "Center");
        this.addButtons();
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassValuePickerCustomizer.this.m_modifyListener != null) {
                    ClassValuePickerCustomizer.this.m_modifyListener.setModifiedStatus(ClassValuePickerCustomizer.this, ClassValuePickerCustomizer.this.m_modified);
                }
                if (ClassValuePickerCustomizer.this.m_textBoxEntryMode) {
                    ClassValuePickerCustomizer.this.m_classValuePicker.setClassValue(ClassValuePickerCustomizer.this.m_valueTextBox.getText().trim());
                }
                if (ClassValuePickerCustomizer.this.m_parent != null) {
                    ClassValuePickerCustomizer.this.m_parent.dispose();
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassValuePickerCustomizer.this.m_classValuePicker.setClassValue(ClassValuePickerCustomizer.this.m_backup);
                ClassValuePickerCustomizer.this.customizerClosing();
                if (ClassValuePickerCustomizer.this.m_parent != null) {
                    ClassValuePickerCustomizer.this.m_parent.dispose();
                }
            }
        });
    }

    private void setupTextBoxSelection() {
        this.m_textBoxEntryMode = true;
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new BorderLayout());
        holderPanel.setBorder(BorderFactory.createTitledBorder("Specify class label"));
        JLabel label = new JLabel("Class label ", 4);
        holderPanel.add((Component)label, "West");
        this.m_valueTextBox = new JTextField(15);
        this.m_valueTextBox.setToolTipText("Class label. /first, /last and /<num> can be used to specify the first, last or specific index of the label to use respectively.");
        holderPanel.add((Component)this.m_valueTextBox, "Center");
        JPanel holder2 = new JPanel();
        holder2.setLayout(new BorderLayout());
        holder2.add((Component)holderPanel, "North");
        this.add((Component)holder2, "Center");
        String existingClassVal = this.m_classValuePicker.getClassValue();
        if (existingClassVal != null) {
            this.m_valueTextBox.setText(existingClassVal);
        }
    }

    private void setUpValueSelection(Instances format) {
        if (format.classIndex() < 0 || format.classAttribute().isNumeric()) {
            this.m_messageLabel.setText(format.classIndex() < 0 ? "EROR: no class attribute set" : "ERROR: class is numeric");
            return;
        }
        if (!this.m_displayValNames) {
            this.remove(this.m_messageLabel);
        }
        this.m_textBoxEntryMode = false;
        if (format.classAttribute().numValues() == 0) {
            this.setupTextBoxSelection();
            this.validate();
            this.repaint();
            return;
        }
        String existingClassVal = this.m_classValuePicker.getClassValue();
        if (existingClassVal == null) {
            existingClassVal = "";
        }
        int classValIndex = format.classAttribute().indexOfValue(existingClassVal);
        if (existingClassVal.startsWith("/")) {
            if ((existingClassVal = existingClassVal.substring(1)).equalsIgnoreCase("first")) {
                classValIndex = 0;
            } else if (existingClassVal.equalsIgnoreCase("last")) {
                classValIndex = format.classAttribute().numValues() - 1;
            } else {
                classValIndex = Integer.parseInt(existingClassVal);
                --classValIndex;
            }
        }
        if (classValIndex < 0) {
            classValIndex = 0;
        }
        String[] attribValNames = new String[format.classAttribute().numValues()];
        for (int i = 0; i < attribValNames.length; ++i) {
            attribValNames[i] = format.classAttribute().value(i);
        }
        this.m_ClassValueCombo.setModel(new DefaultComboBoxModel<String>(attribValNames));
        if (attribValNames.length > 0) {
            this.m_ClassValueCombo.setSelectedIndex(classValIndex);
        }
        if (!this.m_displayValNames) {
            this.add((Component)this.m_holderP, "Center");
            this.m_displayValNames = true;
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void setObject(Object object) {
        if (this.m_classValuePicker != (ClassValuePicker)object) {
            this.m_classValuePicker = (ClassValuePicker)object;
            if (this.m_classValuePicker.getConnectedFormat() != null) {
                this.setUpValueSelection(this.m_classValuePicker.getConnectedFormat());
            }
            this.m_backup = this.m_classValuePicker.getClassValue();
        }
    }

    @Override
    public void customizerClosing() {
        this.m_classValuePicker.setClassValue(this.m_backup);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }
}

