/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import java.io.OutputStream;

public class FastByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public FastByteArrayOutputStream() {
        this(32);
    }

    public FastByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.count];
        System.arraycopy(this.buf, 0, result, 0, this.count);
        return result;
    }

    public void write(byte[] b, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void write(int b) {
        if (this.count >= this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, 1)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
            this.buf = newbuf;
        }
        this.buf[this.count++] = (byte)b;
    }
}

