/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.io.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SpreadSheetCell
extends AbstractTransformer {
    private static final long serialVersionUID = -253714973019682939L;
    protected Index m_Row;
    protected Index m_Column;

    public String globalInfo() {
        return "Extracts a single value from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)"1");
        this.m_OptionManager.add("col", "column", (Object)"1");
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Index();
        this.m_Column = new Index();
    }

    public String getQuickInfo() {
        String variableRow = this.getOptionManager().getVariableForProperty("row");
        String variableCol = this.getOptionManager().getVariableForProperty("column");
        String result = "row: ";
        result = variableRow != null ? result + variableRow : result + this.m_Row.getIndex();
        result = result + "/";
        result = result + "col: ";
        result = variableCol != null ? result + variableCol : result + this.m_Column.getIndex();
        return result;
    }

    public void setRow(String value) {
        this.m_Row.setIndex(value);
        this.reset();
    }

    public String getRow() {
        return this.m_Row.getIndex();
    }

    public String rowTipText() {
        return "The row of the cell to retrieve; " + this.m_Row.getExample();
    }

    public void setColumn(String value) {
        this.m_Column.setIndex(value);
        this.reset();
    }

    public String getColumn() {
        return this.m_Column.getIndex();
    }

    public String columnTipText() {
        return "The column of the cell to retrieve; " + this.m_Column.getExample();
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Row.setMax(sheet.getRowCount());
        this.m_Column.setMax(sheet.getColumnCount());
        if (this.m_Row.getIntIndex() == -1) {
            result = "Illegal row index ('" + this.m_Row.getIndex() + "')?";
        } else if (this.m_Column.getIntIndex() == -1) {
            result = "Illegal column index ('" + this.m_Column.getIndex() + "')?";
        } else {
            String key;
            SpreadSheet.Row row = sheet.getRow(this.m_Row.getIntIndex());
            String value = row.getCell(key = row.getCellKey(this.m_Column.getIntIndex())).isMissing() ? "?" : row.getCell(key).getContent();
            this.m_OutputToken = new Token((Object)value);
        }
        return result;
    }
}

