/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.CSVWriter;
import org.hsqldb.util.ConnectionDialog;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.Grid;
import org.hsqldb.util.RCData;
import org.hsqldb.util.Transfer;
import org.hsqldb.util.Tree;

public class DatabaseManager
extends Applet
implements ActionListener,
WindowListener,
KeyListener {
    private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/dbmanager.rc";
    static final String NL = System.getProperty("line.separator");
    static final int iMaxRecent = 24;
    private static boolean TT_AVAILABLE = false;
    private static final String HELP_TEXT;
    private static final String ABOUT_TEXT;
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    Menu mRecent;
    String[] sRecent;
    int iRecent;
    TextArea txtCommand;
    Button butExecute;
    Button butClear;
    Tree tTree;
    Panel pResult;
    long lTime;
    int iResult;
    Grid gResult;
    TextArea txtResult;
    boolean bHelp;
    Frame fMain;
    Image imgEmpty;
    static boolean bMustExit;
    String ifHuge = "";
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defScript;
    static String defDirectory;
    static /* synthetic */ Class class$org$hsqldb$util$DatabaseManager;

    public void connect(Connection connection) {
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.cConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
            this.refreshTree();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void init() {
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.main();
        try {
            databaseManager.connect(ConnectionDialog.createConnection(defDriver, defURL, defUser, defPassword));
            databaseManager.insertTestData();
            databaseManager.refreshTree();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.getProperties().put("sun.java2d.noddraw", "true");
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        bMustExit = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].toLowerCase();
            if (string3.length() > 1 && string3.charAt(1) == '-') {
                string3 = string3.substring(1);
            }
            if (++i == stringArray.length) {
                DatabaseManager.showUsage();
                return;
            }
            if (string3.equals("-driver")) {
                defDriver = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-url")) {
                defURL = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-user")) {
                defUser = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-password")) {
                defPassword = stringArray[i];
                bl = true;
                continue;
            }
            if (string3.equals("-urlid")) {
                string = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string3.equals("-rcfile")) {
                string2 = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string3.equals("-dir")) {
                defDirectory = stringArray[i];
                continue;
            }
            if (string3.equals("-script")) {
                defScript = stringArray[i];
                continue;
            }
            if (string3.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            DatabaseManager.showUsage();
            return;
        }
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.main();
        Connection connection = null;
        try {
            if (bl && bl2) {
                throw new IllegalArgumentException("You may not specify both (urlid) AND (url/user/password).");
            }
            if (bl) {
                connection = ConnectionDialog.createConnection(defDriver, defURL, defUser, defPassword);
            } else if (bl2) {
                if (string == null) {
                    throw new IllegalArgumentException("You must specify an 'urlid' to use an RC file");
                }
                bl = true;
                if (string2 == null) {
                    string2 = DEFAULT_RCFILE;
                }
                connection = new RCData(new File(string2), string).getConnection(null, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
            } else {
                connection = ConnectionDialog.createConnection(databaseManager.fMain, "Connect");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (connection == null) {
            return;
        }
        databaseManager.connect(connection);
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManager [--options]\nwhere options include:\n    --driver <classname>  jdbc driver class\n    --url <name>          jdbc url\n    --user <name>         username used for connection\n    --password <password> password for this user\n    --urlid <urlid>       use url/user/password/driver in rc file\n    --rcfile <file>       (defaults to 'dbmanager.rc' in home dir)\n    --dir <path>          default directory\n    --script <file>       reads from script file\n    --noexit              do not call system.exit()\n(Single-hypen switches like '-driver' are also supported)");
    }

    void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.refreshTree();
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            this.refreshTree();
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void main() {
        this.fMain = new Frame("HSQL Database Manager");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        MenuBar menuBar = new MenuBar();
        String[] stringArray = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "-Save Result csv...", "--", "-Exit"};
        this.addMenu(menuBar, "File", stringArray);
        String[] stringArray2 = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text", "--", "1Shrink Tree", "2Enlarge Tree", "3Shrink Command", "4Enlarge Command"};
        this.addMenu(menuBar, "View", stringArray2);
        String[] stringArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-CHECKPOINT", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(menuBar, "Command", stringArray3);
        Menu menu = new Menu("Recent");
        this.mRecent = new Menu("Recent");
        menuBar.add(this.mRecent);
        String[] stringArray4 = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(menuBar, "Options", stringArray4);
        String[] stringArray5 = new String[]{"-Dump", "-Restore", "-Transfer"};
        this.addMenu(menuBar, "Tools", stringArray5);
        Menu menu2 = new Menu("Help");
        MenuItem menuItem = new MenuItem("About");
        menuItem.setShortcut(new MenuShortcut(65));
        menuItem.addActionListener(this);
        menu2.add(menuItem);
        MenuItem menuItem2 = new MenuItem("Help");
        menuItem2.setShortcut(new MenuShortcut(72));
        menuItem2.addActionListener(this);
        menu2.add(menuItem2);
        this.fMain.setMenuBar(menuBar);
        this.fMain.setSize(640, 480);
        this.fMain.add("Center", this);
        this.initGUI();
        this.sRecent = new String[24];
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        if (dimension.width >= 640) {
            this.fMain.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(dimension);
        }
        this.fMain.show();
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            this.txtCommand.setText(DatabaseManagerCommon.readFile(defScript));
        }
        this.txtCommand.requestFocus();
    }

    void addMenu(MenuBar menuBar, String string, String[] stringArray) {
        Menu menu = new Menu(string);
        if (string.equals("Tools") && !TT_AVAILABLE) {
            menu.setEnabled(false);
        }
        this.addMenuItems(menu, stringArray);
        menuBar.add(menu);
    }

    void addMenuItems(Menu menu, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            MenuItem menuItem = new MenuItem(stringArray[i].substring(1));
            char c = stringArray[i].charAt(0);
            if (c != '-') {
                menuItem.setShortcut(new MenuShortcut(c));
            }
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.execute();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof MenuItem) {
            string = ((MenuItem)actionEvent.getSource()).getLabel();
        }
        if (string != null) {
            if (string.equals("Execute")) {
                this.execute();
            } else if (string.equals("Clear")) {
                this.clear();
            } else if (string.equals("Exit")) {
                this.windowClosing(null);
            } else if (string.equals("Transfer")) {
                Transfer.work(null);
            } else if (string.equals("Dump")) {
                Transfer.work((String[])new String[]{"-d"});
            } else if (string.equals("Restore")) {
                Transfer.work((String[])new String[]{"-r"});
                this.refreshTree();
            } else if (string.equals("Logging on")) {
                JavaSystem.setLogToSystem(true);
            } else if (string.equals("Logging off")) {
                JavaSystem.setLogToSystem(false);
            } else if (string.equals("Help")) {
                this.showHelp(new String[]{"", HELP_TEXT});
            } else if (string.equals("About")) {
                this.showHelp(new String[]{"", ABOUT_TEXT});
            } else if (string.equals("Refresh Tree")) {
                this.refreshTree();
            } else if (string.startsWith("#")) {
                int n = Integer.parseInt(string.substring(1));
                this.txtCommand.setText(this.sRecent[n]);
            } else if (string.equals("Connect...")) {
                this.connect(ConnectionDialog.createConnection(this.fMain, "Connect"));
                this.refreshTree();
            } else if (string.equals("Results in Grid")) {
                this.iResult = 0;
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
            } else if (string.equals("Open Script...")) {
                FileDialog fileDialog = new FileDialog(this.fMain, "Open Script", 0);
                if (defDirectory != null) {
                    fileDialog.setDirectory(defDirectory);
                }
                fileDialog.show();
                String string2 = fileDialog.getFile();
                if (string2 != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    this.ifHuge = DatabaseManagerCommon.readFile(fileDialog.getDirectory() + string2);
                    if (4096 <= this.ifHuge.length()) {
                        stringBuffer.append("This huge file cannot be edited.\n Please execute or clear\n");
                        this.txtCommand.setText(stringBuffer.toString());
                    } else {
                        this.txtCommand.setText(this.ifHuge);
                    }
                }
            } else if (string.equals("Save Script...")) {
                FileDialog fileDialog = new FileDialog(this.fMain, "Save Script", 1);
                if (defDirectory != null) {
                    fileDialog.setDirectory(defDirectory);
                }
                fileDialog.show();
                String string3 = fileDialog.getFile();
                if (string3 != null) {
                    DatabaseManagerCommon.writeFile(fileDialog.getDirectory() + string3, this.txtCommand.getText());
                }
            } else if (string.equals("Save Result csv...")) {
                FileDialog fileDialog = new FileDialog(this.fMain, "Save Result CSV", 1);
                if (defDirectory != null) {
                    fileDialog.setDirectory(defDirectory);
                }
                fileDialog.show();
                String string4 = fileDialog.getDirectory();
                String string5 = fileDialog.getFile();
                if (string4 != null) {
                    string5 = string4 + "/" + string5;
                }
                if (string5 != null) {
                    this.showResultInText();
                    this.saveAsCsv(string5);
                }
            } else if (string.equals("Save Result...")) {
                FileDialog fileDialog = new FileDialog(this.fMain, "Save Result", 1);
                if (defDirectory != null) {
                    fileDialog.setDirectory(defDirectory);
                }
                fileDialog.show();
                String string6 = fileDialog.getFile();
                if (string6 != null) {
                    this.showResultInText();
                    DatabaseManagerCommon.writeFile(fileDialog.getDirectory() + string6, this.txtResult.getText());
                }
            } else if (string.equals("Results in Text")) {
                this.iResult = 1;
                this.pResult.removeAll();
                this.pResult.add("Center", this.txtResult);
                this.pResult.doLayout();
                this.showResultInText();
            } else if (string.equals("AutoCommit on")) {
                try {
                    this.cConn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            } else if (string.equals("AutoCommit off")) {
                try {
                    this.cConn.setAutoCommit(false);
                }
                catch (SQLException sQLException) {}
            } else if (string.equals("Enlarge Tree")) {
                Dimension dimension = this.tTree.getMinimumSize();
                dimension.width += 20;
                this.tTree.setMinimumSize(dimension);
                this.fMain.pack();
            } else if (string.equals("Shrink Tree")) {
                Dimension dimension = this.tTree.getMinimumSize();
                dimension.width -= 20;
                if (dimension.width >= 0) {
                    this.tTree.setMinimumSize(dimension);
                }
                this.fMain.pack();
            } else if (string.equals("Enlarge Command")) {
                this.txtCommand.setRows(this.txtCommand.getRows() + 1);
                this.fMain.pack();
            } else if (string.equals("Shrink Command")) {
                int n = this.txtCommand.getRows() - 1;
                this.txtCommand.setRows(n < 1 ? 1 : n);
                this.fMain.pack();
            } else if (string.equals("Commit")) {
                try {
                    this.cConn.commit();
                }
                catch (SQLException sQLException) {}
            } else if (string.equals("Insert test data")) {
                this.insertTestData();
            } else if (string.equals("Rollback")) {
                try {
                    this.cConn.rollback();
                }
                catch (SQLException sQLException) {}
            } else if (string.equals("Disable MaxRows")) {
                try {
                    this.sStatement.setMaxRows(0);
                }
                catch (SQLException sQLException) {}
            } else if (string.equals("Set MaxRows to 100")) {
                try {
                    this.sStatement.setMaxRows(100);
                }
                catch (SQLException sQLException) {}
            } else if (string.equals("SELECT")) {
                this.showHelp(DatabaseManagerCommon.selectHelp);
            } else if (string.equals("INSERT")) {
                this.showHelp(DatabaseManagerCommon.insertHelp);
            } else if (string.equals("UPDATE")) {
                this.showHelp(DatabaseManagerCommon.updateHelp);
            } else if (string.equals("DELETE")) {
                this.showHelp(DatabaseManagerCommon.deleteHelp);
            } else if (string.equals("CREATE TABLE")) {
                this.showHelp(DatabaseManagerCommon.createTableHelp);
            } else if (string.equals("DROP TABLE")) {
                this.showHelp(DatabaseManagerCommon.dropTableHelp);
            } else if (string.equals("CREATE INDEX")) {
                this.showHelp(DatabaseManagerCommon.createIndexHelp);
            } else if (string.equals("DROP INDEX")) {
                this.showHelp(DatabaseManagerCommon.dropIndexHelp);
            } else if (string.equals("CHECKPOINT")) {
                this.showHelp(DatabaseManagerCommon.checkpointHelp);
            } else if (string.equals("SCRIPT")) {
                this.showHelp(DatabaseManagerCommon.scriptHelp);
            } else if (string.equals("SHUTDOWN")) {
                this.showHelp(DatabaseManagerCommon.shutdownHelp);
            } else if (string.equals("SET")) {
                this.showHelp(DatabaseManagerCommon.setHelp);
            } else if (string.equals("Test Script")) {
                this.showHelp(DatabaseManagerCommon.testHelp);
            }
        }
    }

    void showHelp(String[] stringArray) {
        this.txtCommand.setText(stringArray[0]);
        this.txtResult.setText(stringArray[1]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add("Center", this.txtResult);
        this.pResult.doLayout();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(stringArray[0].length());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            if (this.cConn != null) {
                this.cConn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void clear() {
        this.ifHuge = "";
        this.txtCommand.setText(this.ifHuge);
    }

    void execute() {
        String string = null;
        string = 4096 <= this.ifHuge.length() ? this.ifHuge : this.txtCommand.getText();
        if (string.startsWith("-->>>TEST<<<--")) {
            this.testPerformance();
            return;
        }
        String[] stringArray = new String[1];
        this.lTime = System.currentTimeMillis();
        try {
            if (this.sStatement == null) {
                return;
            }
            this.sStatement.execute(string);
            this.lTime = System.currentTimeMillis() - this.lTime;
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                stringArray[0] = "update count";
                this.gResult.setHead(stringArray);
                stringArray[0] = String.valueOf(n);
                this.gResult.addRow(stringArray);
            }
            this.addToRecent(this.txtCommand.getText());
        }
        catch (SQLException sQLException) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            stringArray[0] = "SQL Error";
            this.gResult.setHead(stringArray);
            String string2 = sQLException.getMessage();
            string2 = string2 + " / Error Code: " + sQLException.getErrorCode();
            stringArray[0] = string2 = string2 + " / State: " + sQLException.getSQLState();
            this.gResult.addRow(stringArray);
        }
        this.updateResult();
        System.gc();
    }

    void updateResult() {
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
                this.bHelp = false;
            }
            this.gResult.update();
            this.gResult.repaint();
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            String[] stringArray = new String[]{"Result"};
            this.gResult.setHead(stringArray);
            stringArray[0] = "(empty)";
            this.gResult.addRow(stringArray);
            return;
        }
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n2];
            for (n = 1; n <= n2; ++n) {
                stringArray[n - 1] = resultSetMetaData.getColumnLabel(n);
            }
            this.gResult.setHead(stringArray);
            while (resultSet.next()) {
                for (n = 1; n <= n2; ++n) {
                    try {
                        stringArray[n - 1] = resultSet.getString(n);
                        if (!resultSet.wasNull()) continue;
                        stringArray[n - 1] = "(null)";
                        continue;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.gResult.addRow(stringArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void testPerformance() {
        int n;
        String string = this.txtCommand.getText();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 10) continue;
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
        String[] stringArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(stringArray);
        n = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!string.equals("")) {
            String string2;
            int n2 = string.indexOf(59);
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            stringArray[2] = string2;
            long l2 = 0L;
            try {
                l2 = DatabaseManagerCommon.testStatement(this.sStatement, string2, n);
                l += l2;
                stringArray[0] = String.valueOf(l2);
                stringArray[1] = String.valueOf(n);
                stringArray[3] = "";
            }
            catch (SQLException sQLException) {
                stringArray[1] = "n/a";
                stringArray[0] = "n/a";
                stringArray[3] = sQLException.toString();
            }
            this.gResult.addRow(stringArray);
            System.out.println(l2 + " ms : " + string2);
        }
        stringArray[0] = "" + l;
        stringArray[1] = "total";
        stringArray[2] = "";
        this.gResult.addRow(stringArray);
        this.lTime = System.currentTimeMillis() - this.lTime;
        this.updateResult();
    }

    void saveAsCsv(String string) {
        try {
            File file = new File(string);
            CSVWriter cSVWriter = new CSVWriter(file, null);
            String[] stringArray = this.gResult.getHead();
            int n = stringArray.length;
            Vector vector = this.gResult.getData();
            int n2 = vector.size();
            cSVWriter.writeHeader(stringArray);
            for (int i = 0; i < n2; ++i) {
                String[] stringArray2 = (String[])vector.elementAt(i);
                String[] stringArray3 = new String[stringArray2.length];
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string2 = stringArray2[j];
                    if (string2.equals("(null)")) {
                        string2 = "";
                    }
                    stringArray3[j] = string2;
                }
                cSVWriter.writeData(stringArray3);
            }
            cSVWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOError: " + iOException.getMessage());
        }
    }

    void showResultInText() {
        int n;
        int n2;
        String[] stringArray;
        int n3;
        String[] stringArray2 = this.gResult.getHead();
        int n4 = stringArray2.length;
        int[] nArray = new int[n4];
        Vector vector = this.gResult.getData();
        int n5 = vector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = stringArray2[n3].length();
        }
        for (n3 = 0; n3 < n5; ++n3) {
            stringArray = (String[])vector.elementAt(n3);
            for (n2 = 0; n2 < n4; ++n2) {
                n = stringArray[n2].length();
                if (n <= nArray[n2]) continue;
                nArray[n2] = n;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer.append(stringArray2[n2]);
            for (n = stringArray2[n2].length(); n <= nArray[n2]; ++n) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(NL);
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < nArray[n2]; ++n) {
                stringBuffer.append('-');
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append(NL);
        for (n2 = 0; n2 < n5; ++n2) {
            stringArray = (String[])vector.elementAt(n2);
            for (n = 0; n < n4; ++n) {
                stringBuffer.append(stringArray[n]);
                for (int i = stringArray[n].length(); i <= nArray[n]; ++i) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(NL);
        }
        stringBuffer.append(NL + n5 + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        for (int i = 0; i < 24; ++i) {
            if (!string.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand("#" + this.iRecent);
        menuItem.addActionListener(this);
        this.mRecent.insert(menuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % 24;
    }

    private void initGUI() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.pResult = new Panel();
        panel.setLayout(new BorderLayout());
        panel2.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.addKeyListener(this);
        this.txtResult = new TextArea(20, 40);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new Button("Execute");
        this.butClear = new Button("Clear");
        this.butExecute.addActionListener(this);
        this.butClear.addActionListener(this);
        panel2.add("East", this.butExecute);
        panel2.add("West", this.butClear);
        panel2.add("Center", this.txtCommand);
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        this.pResult.add("Center", this.gResult);
        panel.add("North", panel2);
        panel.add("Center", this.pResult);
        this.fMain.add("Center", panel);
        this.tTree = new Tree();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width >= 640) {
            this.tTree.setMinimumSize(new Dimension(200, 100));
        } else {
            this.tTree.setMinimumSize(new Dimension(80, 100));
        }
        this.gResult.setMinimumSize(new Dimension(200, 300));
        this.fMain.add("West", this.tTree);
        this.doLayout();
        this.fMain.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshTree() {
        this.tTree.removeAll();
        try {
            int n = Color.yellow.getRGB();
            int n2 = Color.orange.getRGB();
            int n3 = Color.red.getRGB();
            this.tTree.addRow("", this.dMeta.getURL(), "-", 0);
            String[] stringArray = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            ResultSet resultSet = this.dMeta.getTables(null, null, null, stringArray);
            try {
                while (resultSet.next()) {
                    vector.addElement(resultSet.getString(2));
                    vector2.addElement(resultSet.getString(3));
                    vector3.addElement(resultSet.getString(5));
                }
            }
            finally {
                resultSet.close();
            }
            for (int i = 0; i < vector2.size(); ++i) {
                String string;
                Object object;
                String string2 = (String)vector2.elementAt(i);
                String string3 = (String)vector.elementAt(i);
                String string4 = "tab-" + string2 + "-";
                this.tTree.addRow(string4, string2, "+", n);
                String string5 = (String)vector3.elementAt(i);
                if (string3 != null && !string3.trim().equals("")) {
                    this.tTree.addRow(string4 + "s", "schema: " + string3);
                }
                if (string5 != null && !string5.trim().equals("")) {
                    this.tTree.addRow(string4 + "r", " " + string5);
                }
                ResultSet resultSet2 = this.dMeta.getColumns(null, string3, string2, null);
                try {
                    while (resultSet2.next()) {
                        object = resultSet2.getString(4);
                        string = string4 + "col-" + (String)object + "-";
                        this.tTree.addRow(string, (String)object, "+", n2);
                        String string6 = resultSet2.getString(6);
                        this.tTree.addRow(string + "t", "Type: " + string6);
                        boolean bl = resultSet2.getInt(11) != 0;
                        this.tTree.addRow(string + "n", "Nullable: " + bl);
                    }
                }
                finally {
                    resultSet2.close();
                }
                this.tTree.addRow(string4 + "ind", "Indices", "+", 0);
                object = this.dMeta.getIndexInfo(null, string3, string2, false, false);
                string = null;
                try {
                    while (object.next()) {
                        boolean bl = object.getBoolean(4);
                        String string7 = object.getString(6);
                        String string8 = string4 + "ind-" + string7 + "-";
                        if (string == null || !string.equals(string7)) {
                            this.tTree.addRow(string8, string7, "+", n3);
                            this.tTree.addRow(string8 + "u", "Unique: " + !bl);
                            string = string7;
                        }
                        String string9 = object.getString(9);
                        this.tTree.addRow(string8 + "c-" + string9 + "-", string9);
                    }
                    continue;
                }
                finally {
                    object.close();
                }
            }
            this.tTree.addRow("p", "Properties", "+", 0);
            this.tTree.addRow("pu", "User: " + this.dMeta.getUserName());
            this.tTree.addRow("pr", "ReadOnly: " + this.cConn.isReadOnly());
            this.tTree.addRow("pa", "AutoCommit: " + this.cConn.getAutoCommit());
            this.tTree.addRow("pd", "Driver: " + this.dMeta.getDriverName());
            this.tTree.addRow("pp", "Product: " + this.dMeta.getDatabaseProductName());
            this.tTree.addRow("pv", "Version: " + this.dMeta.getDatabaseProductVersion());
        }
        catch (SQLException sQLException) {
            this.tTree.addRow("", "Error getting metadata:", "-", 0);
            this.tTree.addRow("-", sQLException.getMessage());
            this.tTree.addRow("-", sQLException.getSQLState());
        }
        this.tTree.update();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName((class$org$hsqldb$util$DatabaseManager == null ? (class$org$hsqldb$util$DatabaseManager = DatabaseManager.class$("org.hsqldb.util.DatabaseManager")) : class$org$hsqldb$util$DatabaseManager).getPackage().getName() + ".Transfer");
            TT_AVAILABLE = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HELP_TEXT = "See the forums, mailing lists, and HSQLDB User Guide\nat http://hsqldb.org.\n\nPlease paste the following version identifier with any\nproblem reports or help requests:  $Revision: 1.37 $" + (TT_AVAILABLE ? "" : "\n\nTransferTool classes are not in CLASSPATH.\nTo enable the Tools menu, add 'transfer.jar' to your class path.");
        ABOUT_TEXT = "$Revision: 1.37 $ of DatabaseManagerSwing\n\nCopyright (c) 1995-2000, The Hypersonic SQL Group.\nCopyright (c) 2001-2007, The HSQL Development Group.\nhttp://hsqldb.org  (User Guide available at this site).\n\n\nYou may use and redistribute according to the HSQLDB\nlicense documented in the source code and at the web\nsite above." + (TT_AVAILABLE ? "\n\nTransferTool options are available." : "");
        defDriver = "org.hsqldb.jdbcDriver";
        defURL = "jdbc:hsqldb:.";
        defUser = "sa";
        defPassword = "";
    }
}

