/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.io.IntelligentFileWriter;

public abstract class ExportMatrixPLT {
    public static void toFile(File file, Matrix matrix, Object ... parameters) throws Exception {
        IntelligentFileWriter writer = new IntelligentFileWriter(file);
        ExportMatrixPLT.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toStream(OutputStream outputStream, Matrix matrix, Object ... parameters) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        ExportMatrixPLT.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toWriter(Writer writer, Matrix matrix, Object ... parameters) throws Exception {
        String EOL = System.getProperty("line.separator");
        boolean xy = false;
        boolean logx = false;
        boolean logy = false;
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            String s = StringUtil.getString(o);
            if ("logx".equalsIgnoreCase(s)) {
                logx = true;
            } else if ("logy".equalsIgnoreCase(s)) {
                logy = true;
            } else if ("xy".equalsIgnoreCase(s)) {
                xy = true;
            }
            ++n2;
        }
        ExportMatrixPLT.writeData(writer, matrix, xy, logx, logy);
        writer.write("pause -1 'Export plot to eps?'" + EOL);
        writer.write("set output 'plot" + System.currentTimeMillis() + ".eps'" + EOL);
        writer.write("set terminal postscript eps" + EOL);
        writer.write("replot" + EOL);
        ExportMatrixPLT.writeData(writer, matrix, xy, logx, logy);
    }

    private static void writeData(Writer writer, Matrix matrix, boolean xy, boolean logx, boolean logy) throws Exception {
        int startColumn;
        String EOL = System.getProperty("line.separator");
        writer.write("set key outside below" + EOL);
        writer.write("set autoscale fix" + EOL);
        if (logx && logy) {
            writer.write("set log xy" + EOL);
        } else if (logx) {
            writer.write("set log x" + EOL);
        } else if (logx) {
            writer.write("set log x" + EOL);
        }
        if (xy) {
            String x = matrix.getColumnLabel(0L);
            x = x == null ? "column 0" : x;
            writer.write("set xlabel '" + x + "'" + EOL);
        } else {
            writer.write("set xlabel 'column'" + EOL);
        }
        writer.write("set title '" + StringUtil.format(matrix.getLabel()) + "'" + EOL);
        writer.write("plot ");
        int c = startColumn = xy ? 1 : 0;
        while ((long)c < matrix.getColumnCount()) {
            String x = matrix.getColumnLabel(c);
            x = x == null ? "column " + c : x;
            writer.write("'-' using 1:2 title '" + x + "' with linespoints");
            if ((long)c < matrix.getColumnCount() - 1L) {
                writer.write(", ");
            } else {
                writer.write(EOL);
            }
            ++c;
        }
        if (xy) {
            c = 1;
            while ((long)c < matrix.getColumnCount()) {
                int r = 0;
                while ((long)r < matrix.getRowCount()) {
                    writer.write(String.valueOf(matrix.getAsDouble(r, 0L)) + " " + matrix.getAsDouble(r, c) + EOL);
                    ++r;
                }
                writer.write("e" + EOL);
                ++c;
            }
        } else {
            c = 0;
            while ((long)c < matrix.getColumnCount()) {
                int r = 0;
                while ((long)r < matrix.getRowCount()) {
                    writer.write(String.valueOf(r) + " " + matrix.getAsDouble(r, c) + EOL);
                    ++r;
                }
                writer.write("e" + EOL);
                ++c;
            }
        }
    }
}

