/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.util.Arrays;
import org.ujmp.core.Matrix;

public abstract class VerifyUtil {
    public static final void assertTrue(boolean test, String message, Object ... messageArgs) {
        if (!test) {
            String text = messageArgs == null || messageArgs.length == 0 ? message : String.format(message, messageArgs);
            throw new IllegalArgumentException(text);
        }
    }

    public static final void assertFalse(boolean test, String message, Object ... messageArgs) {
        if (!test) {
            String text = messageArgs == null || messageArgs.length == 0 ? message : String.format(message, messageArgs);
            throw new IllegalArgumentException(text);
        }
    }

    public static final void assertTrue(boolean test, String message) {
        if (!test) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final void assertFalse(boolean test, String message) {
        if (test) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final void assertSameSize(Matrix m1, Matrix m2) {
        VerifyUtil.assertTrue(Arrays.equals(m1.getSize(), m2.getSize()), "matrices have different sizes");
    }

    public static void assertSameSize(Matrix ... matrices) {
        VerifyUtil.assertTrue(matrices.length > 1, "more than one matrix must be provided");
        int i = matrices.length;
        while (--i != 0) {
            VerifyUtil.assertTrue(Arrays.equals(matrices[i].getSize(), matrices[i - 1].getSize()), "matrices have different sizes");
        }
    }

    public static void assertSameSize(double[][] source1, double[][] source2, double[][] target) {
        VerifyUtil.assertNotNull(source1, "matrix1 cannot be null");
        VerifyUtil.assertNotNull(source2, "matrix2 cannot be null");
        VerifyUtil.assertNotNull(target, "matrix3 cannot be null");
        VerifyUtil.assertNotNull(source1[0], "matrix1 must be 2d");
        VerifyUtil.assertNotNull(source2[0], "matrix2 must be 2d");
        VerifyUtil.assertNotNull(target[0], "matrix3 must be 2d");
        VerifyUtil.assertEquals(source1.length, source2.length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.assertEquals(source2.length, target.length, "matrix1 and matrix3 have different sizes");
        VerifyUtil.assertEquals(source1[0].length, source2[0].length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.assertEquals(source2[0].length, target[0].length, "matrix1 and matrix3 have different sizes");
    }

    public static void assertEquals(int i1, int i2, String message) {
        VerifyUtil.assertTrue(i1 == i2, message);
    }

    public static void assertNotNull(Object o, String message) {
        VerifyUtil.assertFalse(o == null, message);
    }

    public static void assertNull(Object o, String message) {
        VerifyUtil.assertTrue(o == null, message);
    }

    public static void assertSameSize(double[] source1, double[] source2, double[] target) {
        VerifyUtil.assertNotNull(source1, "matrix1 cannot be null");
        VerifyUtil.assertNotNull(source2, "matrix2 cannot be null");
        VerifyUtil.assertNotNull(target, "matrix3 cannot be null");
        VerifyUtil.assertEquals(source1.length, source2.length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.assertEquals(source2.length, target.length, "matrix1 and matrix3 have different sizes");
    }

    public static void assertSameSize(double[][] source, double[][] target) {
        VerifyUtil.assertNotNull(source, "matrix1 cannot be null");
        VerifyUtil.assertNotNull(target, "matrix2 cannot be null");
        VerifyUtil.assertNotNull(source[0], "matrix1 must be 2d");
        VerifyUtil.assertNotNull(target[0], "matrix2 must be 2d");
        VerifyUtil.assertEquals(source.length, target.length, "matrix1 and matrix2 have different sizes");
        VerifyUtil.assertEquals(source[0].length, target[0].length, "matrix1 and matrix2 have different sizes");
    }

    public static void assertSameSize(double[] source, double[] target) {
        VerifyUtil.assertNotNull(source, "matrix1 cannot be null");
        VerifyUtil.assertNotNull(target, "matrix2 cannot be null");
        VerifyUtil.assertEquals(source.length, target.length, "matrix1 and matrix2 have different sizes");
    }

    public static void assert2D(Matrix m) {
        VerifyUtil.assertNotNull(m, "matrix cannot be null");
        VerifyUtil.assertEquals(m.getDimensionCount(), 2, "matrix is not 2d");
    }

    public static void assertEquals(long l1, long l2, String message) {
        VerifyUtil.assertTrue(l1 == l2, message);
    }
}

