/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustree;

import java.util.ArrayList;
import java.util.LinkedList;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.clustree.ClusKernel;
import moa.clusterers.clustree.Entry;
import moa.clusterers.clustree.Node;
import moa.clusterers.clustree.util.Budget;
import moa.clusterers.clustree.util.SimpleBudget;
import moa.core.Measurement;
import moa.options.IntOption;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusTree
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    public IntOption horizonOption = new IntOption("horizon", 'h', "Range of the window.", 1000);
    public IntOption maxHeightOption = new IntOption("maxHeight", 'H', "The maximal height of the tree", this.getDefaultHeight());
    private static int INSERTIONS_BETWEEN_CLEANUPS = 10000;
    protected Node root;
    private int numberDimensions;
    protected double negLambda;
    private int height;
    protected int maxHeight;
    private int numRootSplits;
    private double weightThreshold = 0.05;
    private int numberInsertions;
    private long timestamp;
    protected boolean breadthFirstStrat = false;
    private Entry alsoUpdate;

    protected int getDefaultHeight() {
        return 8;
    }

    @Override
    public void resetLearningImpl() {
        this.negLambda = 1.0 / (double)this.horizonOption.getValue() * (Math.log(this.weightThreshold) / Math.log(2.0));
        this.maxHeight = this.maxHeightOption.getValue();
        this.numberDimensions = -1;
        this.root = null;
        this.timestamp = 0L;
        this.height = 0;
        this.numRootSplits = 0;
        this.numberInsertions = 0;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return null;
    }

    @Override
    public boolean implementsMicroClusterer() {
        return true;
    }

    @Override
    public void trainOnInstanceImpl(Instance instance) {
        ++this.timestamp;
        if (this.root == null) {
            this.numberDimensions = instance.numAttributes();
            this.root = new Node(this.numberDimensions, 0);
        } else if (this.numberDimensions != instance.numAttributes()) {
            System.out.println("Wrong dimensionality, expected:" + this.numberDimensions + "found:" + instance.numAttributes());
        }
        ClusKernel newPointAsKernel = new ClusKernel(instance.toDoubleArray(), this.numberDimensions);
        this.insert(newPointAsKernel, new SimpleBudget(1000), this.timestamp);
    }

    public void insert(ClusKernel newPoint, Budget budget, long timestamp) {
        if (this.breadthFirstStrat) {
            this.insertBreadthFirst(newPoint, budget, timestamp);
        } else {
            ClusKernel carriedBuffer = new ClusKernel(this.numberDimensions);
            Entry rootEntry = new Entry(this.numberDimensions, this.root, timestamp, null, null);
            Entry toInsertHere = this.insert(newPoint, carriedBuffer, this.root, rootEntry, budget, timestamp);
            if (toInsertHere != null) {
                ++this.numRootSplits;
                this.height += this.height < this.maxHeight ? 1 : 0;
                Node newRoot = new Node(this.numberDimensions, toInsertHere.getChild().getRawLevel() + 1);
                newRoot.addEntry(rootEntry, timestamp);
                newRoot.addEntry(toInsertHere, timestamp);
                rootEntry.setNode(newRoot);
                toInsertHere.setNode(newRoot);
                this.root = newRoot;
            }
        }
        ++this.numberInsertions;
        if (this.numberInsertions % INSERTIONS_BETWEEN_CLEANUPS == 0) {
            this.cleanUp(this.root, 0);
        }
    }

    private Entry insertBreadthFirst(ClusKernel newPoint, Budget budget, long timestamp) {
        Node bestFit = this.findBestLeafNode(newPoint);
        bestFit.makeOlder(timestamp, this.negLambda);
        Entry parent = bestFit.getEntries()[0].getParentEntry();
        Entry irrelevantEntry = bestFit.getIrrelevantEntry(this.weightThreshold);
        int numFreeEntries = bestFit.numFreeEntries();
        Entry newEntry = new Entry(newPoint.getCenter().length, newPoint, timestamp, parent, bestFit);
        if (numFreeEntries > 0) {
            bestFit.addEntry(newEntry, timestamp);
        } else if (irrelevantEntry != null) {
            irrelevantEntry.overwriteOldEntry(newEntry);
        } else if (this.existsOutdatedEntryOnPath(bestFit) || !this.hasMaximalSize()) {
            this.insertHereWithSplit(newEntry, bestFit, timestamp);
        } else {
            this.mergeEntryWithoutSplit(bestFit, newEntry, timestamp);
        }
        if (bestFit.getEntries()[0].getParentEntry() != null) {
            this.updateToTop(bestFit.getEntries()[0].getParentEntry().getNode());
        }
        return null;
    }

    private boolean existsOutdatedEntryOnPath(Node node) {
        if (node == this.root) {
            node.makeOlder(this.timestamp, this.negLambda);
            return node.getIrrelevantEntry(this.weightThreshold) != null;
        }
        do {
            node = node.getEntries()[0].getParentEntry().getNode();
            node.makeOlder(this.timestamp, this.negLambda);
            for (Entry e : node.getEntries()) {
                e.recalculateData();
            }
            if (node.numFreeEntries() > 0) {
                return true;
            }
            if (node.getIrrelevantEntry(this.weightThreshold) == null) continue;
            return true;
        } while (node.getEntries()[0].getParentEntry() != null);
        return false;
    }

    private void updateToTop(Node toUpdate) {
        while (toUpdate != null) {
            for (Entry e : toUpdate.getEntries()) {
                e.recalculateData();
            }
            if (toUpdate.getEntries()[0].getParentEntry() == null) break;
            toUpdate = toUpdate.getEntries()[0].getParentEntry().getNode();
        }
    }

    private Entry insertHereWithSplit(Entry toInsert, Node insertNode, long timestamp) {
        if (insertNode.getEntries()[0].getParentEntry() == null) {
            this.root.makeOlder(timestamp, this.negLambda);
            Entry irrelevantEntry = insertNode.getIrrelevantEntry(this.weightThreshold);
            int numFreeEntries = insertNode.numFreeEntries();
            if (irrelevantEntry != null) {
                irrelevantEntry.overwriteOldEntry(toInsert);
            } else if (numFreeEntries > 0) {
                insertNode.addEntry(toInsert, timestamp);
            } else {
                ++this.numRootSplits;
                this.height += this.height < this.maxHeight ? 1 : 0;
                Entry oldRootEntry = new Entry(this.numberDimensions, this.root, timestamp, null, null);
                Node newRoot = new Node(this.numberDimensions, this.height);
                Entry newRootEntry = this.split(toInsert, this.root, oldRootEntry, timestamp);
                newRoot.addEntry(oldRootEntry, timestamp);
                newRoot.addEntry(newRootEntry, timestamp);
                this.root = newRoot;
                for (Entry c : oldRootEntry.getChild().getEntries()) {
                    c.setParentEntry(this.root.getEntries()[0]);
                }
                for (Entry c : newRootEntry.getChild().getEntries()) {
                    c.setParentEntry(this.root.getEntries()[1]);
                }
            }
            return null;
        }
        insertNode.makeOlder(timestamp, this.negLambda);
        Entry irrelevantEntry = insertNode.getIrrelevantEntry(this.weightThreshold);
        int numFreeEntries = insertNode.numFreeEntries();
        if (irrelevantEntry != null) {
            irrelevantEntry.overwriteOldEntry(toInsert);
        } else if (numFreeEntries > 0) {
            insertNode.addEntry(toInsert, timestamp);
        } else {
            Entry parentEntry = insertNode.getEntries()[0].getParentEntry();
            Entry residualEntry = this.split(toInsert, insertNode, parentEntry, timestamp);
            if (this.alsoUpdate != null) {
                this.alsoUpdate = residualEntry;
            }
            Node nodeForResidualEntry = insertNode.getEntries()[0].getParentEntry().getNode();
            return this.insertHereWithSplit(residualEntry, nodeForResidualEntry, timestamp);
        }
        return null;
    }

    private Entry insertHere(Entry newEntry, Node currentNode, Entry parentEntry, ClusKernel carriedBuffer, Budget budget, long timestamp) {
        int numFreeEntries = currentNode.numFreeEntries();
        if (!carriedBuffer.isEmpty()) {
            Entry bufferEntry = new Entry(this.numberDimensions, carriedBuffer, timestamp, parentEntry, currentNode);
            if (numFreeEntries <= 1) {
                Entry nearestEntryToCarriedBuffer = currentNode.nearestEntry(newEntry);
                double distanceNearestEntryToBuffer = nearestEntryToCarriedBuffer.calcDistance(newEntry);
                double distanceBufferNewEntry = newEntry.calcDistance(carriedBuffer);
                BestMergeInNode bestMergeInNode = this.calculateBestMergeInNode(currentNode);
                if (distanceNearestEntryToBuffer <= distanceBufferNewEntry && distanceNearestEntryToBuffer <= bestMergeInNode.distance) {
                    nearestEntryToCarriedBuffer.aggregateEntry(bufferEntry, timestamp, this.negLambda);
                } else if (distanceBufferNewEntry <= distanceNearestEntryToBuffer && distanceBufferNewEntry <= bestMergeInNode.distance) {
                    newEntry.mergeWith(bufferEntry);
                } else {
                    currentNode.mergeEntries(bestMergeInNode.entryPos1, bestMergeInNode.entryPos2);
                    currentNode.addEntry(bufferEntry, timestamp);
                }
            } else {
                assert (currentNode.isLeaf());
                currentNode.addEntry(bufferEntry, timestamp);
            }
        }
        numFreeEntries = currentNode.numFreeEntries();
        Entry irrelevantEntry = currentNode.getIrrelevantEntry(this.weightThreshold);
        if (currentNode.isLeaf() && irrelevantEntry != null) {
            irrelevantEntry.overwriteOldEntry(newEntry);
        } else if (numFreeEntries >= 1) {
            currentNode.addEntry(newEntry, timestamp);
        } else if (currentNode.isLeaf() && (this.hasMaximalSize() || !budget.hasMoreTime())) {
            this.mergeEntryWithoutSplit(currentNode, newEntry, timestamp);
        } else {
            return this.split(newEntry, currentNode, parentEntry, timestamp);
        }
        return null;
    }

    private Node findBestLeafNode(ClusKernel newPoint) {
        double minDist = Double.MAX_VALUE;
        Node bestFit = null;
        for (Node e : this.collectLeafNodes(this.root)) {
            if (!(newPoint.calcDistance(e.nearestEntry(newPoint).getData()) < minDist)) continue;
            bestFit = e;
            minDist = newPoint.calcDistance(e.nearestEntry(newPoint).getData());
        }
        if (bestFit != null) {
            return bestFit;
        }
        return this.root;
    }

    private ArrayList<Node> collectLeafNodes(Node curr) {
        ArrayList<Node> toReturn = new ArrayList<Node>();
        if (curr == null) {
            return toReturn;
        }
        if (curr.isLeaf()) {
            toReturn.add(curr);
            return toReturn;
        }
        for (Entry e : curr.getEntries()) {
            toReturn.addAll(this.collectLeafNodes(e.getChild()));
        }
        return toReturn;
    }

    private Entry insert(ClusKernel pointToInsert, ClusKernel carriedBuffer, Node currentNode, Entry parentEntry, Budget budget, long timestamp) {
        assert (currentNode != null);
        assert (currentNode.isLeaf() || currentNode.getEntries()[0].getChild() != null);
        currentNode.makeOlder(timestamp, this.negLambda);
        Entry toInsertHere = null;
        if (currentNode.isLeaf()) {
            toInsertHere = new Entry(this.numberDimensions, pointToInsert, timestamp, parentEntry, currentNode);
        } else {
            Entry bestEntry = currentNode.nearestEntry(pointToInsert);
            bestEntry.aggregateCluster(pointToInsert, timestamp, this.negLambda);
            boolean isCarriedBufferEmpty = carriedBuffer.isEmpty();
            Entry bestBufferEntry = null;
            if (!isCarriedBufferEmpty) {
                bestBufferEntry = currentNode.nearestEntry(carriedBuffer);
                bestBufferEntry.aggregateCluster(carriedBuffer, timestamp, this.negLambda);
            }
            if (!budget.hasMoreTime()) {
                bestEntry.aggregateToBuffer(pointToInsert, timestamp, this.negLambda);
                if (!isCarriedBufferEmpty) {
                    bestBufferEntry.aggregateToBuffer(carriedBuffer, timestamp, this.negLambda);
                }
                return null;
            }
            if (!isCarriedBufferEmpty && bestEntry != bestBufferEntry) {
                bestBufferEntry.aggregateToBuffer(carriedBuffer, timestamp, this.negLambda);
                carriedBuffer.clear();
            }
            ClusKernel takeAlongBuffer = bestEntry.emptyBuffer(timestamp, this.negLambda);
            carriedBuffer.add(takeAlongBuffer);
            toInsertHere = this.insert(pointToInsert, carriedBuffer, bestEntry.getChild(), bestEntry, budget, timestamp);
        }
        if (toInsertHere != null) {
            return this.insertHere(toInsertHere, currentNode, parentEntry, carriedBuffer, budget, timestamp);
        }
        return null;
    }

    private void mergeEntryWithoutSplit(Node node, Entry newEntry, long timestamp) {
        Entry nearestEntryToCarriedBuffer = node.nearestEntry(newEntry);
        double distanceNearestEntryToBuffer = nearestEntryToCarriedBuffer.calcDistance(newEntry);
        BestMergeInNode bestMergeInNode = this.calculateBestMergeInNode(node);
        if (distanceNearestEntryToBuffer < bestMergeInNode.distance) {
            nearestEntryToCarriedBuffer.aggregateEntry(newEntry, timestamp, this.negLambda);
        } else {
            node.mergeEntries(bestMergeInNode.entryPos1, bestMergeInNode.entryPos2);
            node.addEntry(newEntry, timestamp);
        }
    }

    private BestMergeInNode calculateBestMergeInNode(Node node) {
        assert (node.numFreeEntries() == 0);
        Entry[] entries = node.getEntries();
        int toMerge1 = -1;
        int toMerge2 = -1;
        double distanceBetweenMergeEntries = Double.NaN;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < entries.length; ++i) {
            Entry e1 = entries[i];
            for (int j = i + 1; j < entries.length; ++j) {
                Entry e2 = entries[j];
                double distance = e1.calcDistance(e2);
                if (!(distance < minDistance)) continue;
                toMerge1 = i;
                toMerge2 = j;
                distanceBetweenMergeEntries = distance;
            }
        }
        assert (toMerge1 != -1 && toMerge2 != -1);
        if (Double.isNaN(distanceBetweenMergeEntries)) {
            throw new RuntimeException("The minimal distance between two Entrys in a Node was Double.MAX_VAUE. That can hardly be right.");
        }
        return new BestMergeInNode(toMerge1, toMerge2, distanceBetweenMergeEntries);
    }

    private boolean hasMaximalSize() {
        return this.height == this.maxHeight;
    }

    private Entry split(Entry newEntry, Node node, Entry parentEntry, long timestamp) {
        assert (node.numFreeEntries() == 0);
        assert (parentEntry.getChild() == node);
        Entry[] allEntries = new Entry[4];
        Entry[] nodeEntries = node.getEntries();
        for (int i = 0; i < nodeEntries.length; ++i) {
            allEntries[i] = new Entry(nodeEntries[i]);
        }
        allEntries[3] = newEntry;
        node = new Node(this.numberDimensions, node.getRawLevel());
        double select01 = allEntries[0].calcDistance(allEntries[1]) + allEntries[2].calcDistance(allEntries[3]);
        double select02 = allEntries[0].calcDistance(allEntries[2]) + allEntries[1].calcDistance(allEntries[3]);
        double select03 = allEntries[0].calcDistance(allEntries[3]) + allEntries[1].calcDistance(allEntries[2]);
        Node residualNode = new Node(this.numberDimensions, node.getRawLevel());
        if (select01 < select02) {
            if (select01 < select03) {
                node.addEntry(allEntries[0], timestamp);
                node.addEntry(allEntries[1], timestamp);
                residualNode.addEntry(allEntries[2], timestamp);
                residualNode.addEntry(allEntries[3], timestamp);
            } else {
                node.addEntry(allEntries[0], timestamp);
                node.addEntry(allEntries[3], timestamp);
                residualNode.addEntry(allEntries[1], timestamp);
                residualNode.addEntry(allEntries[2], timestamp);
            }
        } else if (select02 < select03) {
            node.addEntry(allEntries[0], timestamp);
            node.addEntry(allEntries[2], timestamp);
            residualNode.addEntry(allEntries[1], timestamp);
            residualNode.addEntry(allEntries[3], timestamp);
        } else {
            node.addEntry(allEntries[0], timestamp);
            node.addEntry(allEntries[3], timestamp);
            residualNode.addEntry(allEntries[1], timestamp);
            residualNode.addEntry(allEntries[2], timestamp);
        }
        parentEntry.setChild(node);
        parentEntry.recalculateData();
        int count = 0;
        for (Entry e : node.getEntries()) {
            e.setParentEntry(parentEntry);
            if (e.getData().getN() == 0.0) continue;
            ++count;
        }
        Entry residualEntry = new Entry(this.numberDimensions, residualNode, timestamp, parentEntry, node);
        count = 0;
        for (Entry e : residualNode.getEntries()) {
            e.setParentEntry(residualEntry);
            if (e.getData().getN() == 0.0) continue;
            ++count;
        }
        return residualEntry;
    }

    public int getNumRootSplits() {
        return this.numRootSplits;
    }

    public int getHeight() {
        assert (this.height <= this.maxHeight);
        return this.height;
    }

    private void cleanUp(Node currentNode, int level) {
        if (currentNode == null) {
            return;
        }
        Entry[] entries = currentNode.getEntries();
        if (level == this.maxHeight) {
            for (int i = 0; i < entries.length; ++i) {
                Entry e = entries[i];
                e.setChild(null);
            }
        } else {
            for (int i = 0; i < entries.length; ++i) {
                Entry e = entries[i];
                this.cleanUp(e.getChild(), level + 1);
            }
        }
    }

    @Override
    public Clustering getMicroClusteringResult() {
        return this.getClustering(this.timestamp, -1);
    }

    @Override
    public Clustering getClusteringResult() {
        return null;
    }

    public Clustering getClustering(long currentTime, int targetLevel) {
        if (this.root == null) {
            return null;
        }
        Clustering clusters = new Clustering();
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            Entry entry;
            int i;
            Entry[] entries;
            boolean isLeaf;
            Node current = (Node)queue.remove();
            int currentLevel = current.getLevel(this);
            boolean bl = isLeaf = current.isLeaf() && currentLevel <= this.maxHeight || currentLevel == this.maxHeight;
            if (currentLevel == targetLevel || targetLevel == -1 && isLeaf) {
                assert (currentLevel <= this.maxHeight);
                entries = current.getEntries();
                for (i = 0; i < entries.length; ++i) {
                    entry = entries[i];
                    if (entry == null || entry.isEmpty()) continue;
                    entry.makeOlder(currentTime, this.negLambda);
                    if (entry.isIrrelevant(this.weightThreshold)) continue;
                    ClusKernel gaussKernel = new ClusKernel(entry.getData());
                    clusters.add(gaussKernel);
                }
                continue;
            }
            if (current.isLeaf()) continue;
            entries = current.getEntries();
            for (i = 0; i < entries.length; ++i) {
                entry = entries[i];
                if (entry.isEmpty() || entry.isIrrelevant(this.weightThreshold)) continue;
                queue.add(entry.getChild());
            }
        }
        return clusters;
    }

    class BestMergeInNode {
        public int entryPos1;
        public int entryPos2;
        public double distance;

        public BestMergeInNode(int pos1, int pos2, double distance) {
            assert (pos1 != pos2);
            this.distance = distance;
            if (pos1 < pos2) {
                this.entryPos1 = pos1;
                this.entryPos2 = pos2;
            } else {
                this.entryPos1 = pos2;
                this.entryPos2 = pos1;
            }
        }
    }
}

