/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class HyperplaneGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public IntOption numClassesOption = new IntOption("numClasses", 'c', "The number of classes to generate.", 2, 2, Integer.MAX_VALUE);
    public IntOption numAttsOption = new IntOption("numAtts", 'a', "The number of attributes to generate.", 10, 0, Integer.MAX_VALUE);
    public IntOption numDriftAttsOption = new IntOption("numDriftAtts", 'k', "The number of attributes with drift.", 2, 0, Integer.MAX_VALUE);
    public FloatOption magChangeOption = new FloatOption("magChange", 't', "Magnitude of the change for every example", 0.0, 0.0, 1.0);
    public IntOption noisePercentageOption = new IntOption("noisePercentage", 'n', "Percentage of noise to add to the data.", 5, 0, 100);
    public IntOption sigmaPercentageOption = new IntOption("sigmaPercentage", 's', "Percentage of probability that the direction of change is reversed.", 10, 0, 100);
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected double[] weights;
    protected int[] sigma;
    public int numberInstance;

    public String getPurposeString() {
        return "Generates a problem of predicting class of a rotating hyperplane.";
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        monitor.setCurrentActivity("Preparing hyperplane...", -1.0);
        this.generateHeader();
        this.restart();
    }

    protected void generateHeader() {
        FastVector attributes = new FastVector();
        for (int i = 0; i < this.numAttsOption.getValue(); ++i) {
            attributes.addElement((Object)new Attribute("att" + (i + 1)));
        }
        FastVector classLabels = new FastVector();
        for (int i = 0; i < this.numClassesOption.getValue(); ++i) {
            classLabels.addElement((Object)("class" + (i + 1)));
        }
        attributes.addElement((Object)new Attribute("class", (List)classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), (ArrayList)attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
    }

    public long estimatedRemainingInstances() {
        return -1L;
    }

    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    public boolean hasMoreInstances() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public Instance nextInstance() {
        int numAtts = this.numAttsOption.getValue();
        double[] attVals = new double[numAtts + 1];
        double sum = 0.0;
        double sumWeights = 0.0;
        for (int i = 0; i < numAtts; ++i) {
            attVals[i] = this.instanceRandom.nextDouble();
            sum += this.weights[i] * attVals[i];
            sumWeights += this.weights[i];
        }
        boolean classLabel = sum >= sumWeights * 0.5;
        if (1 + this.instanceRandom.nextInt(100) <= this.noisePercentageOption.getValue()) {
            classLabel = !classLabel;
        }
        DenseInstance inst = new DenseInstance(1.0, attVals);
        inst.setDataset((Instances)this.getHeader());
        inst.setClassValue((double)classLabel);
        this.addDrift();
        return inst;
    }

    private void addDrift() {
        for (int i = 0; i < this.numDriftAttsOption.getValue(); ++i) {
            int n = i;
            this.weights[n] = this.weights[n] + (double)this.sigma[i] * this.magChangeOption.getValue();
            if (1 + this.instanceRandom.nextInt(100) > this.sigmaPercentageOption.getValue()) continue;
            int n2 = i;
            this.sigma[n2] = this.sigma[n2] * -1;
        }
    }

    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.weights = new double[this.numAttsOption.getValue()];
        this.sigma = new int[this.numAttsOption.getValue()];
        for (int i = 0; i < this.numAttsOption.getValue(); ++i) {
            this.weights[i] = this.instanceRandom.nextDouble();
            this.sigma[i] = i < this.numDriftAttsOption.getValue() ? 1 : 0;
        }
    }

    public void getDescription(StringBuilder sb, int indent) {
    }
}

