/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.FileBasedProducer;
import adams.core.option.OptionHandler;
import adams.flow.control.AbstractTee;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.IfThenElse;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractGlobalActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;

public class FlowStructureDotProducer
extends AbstractRecursiveOptionProducer<String, String>
implements FileBasedProducer {
    private static final long serialVersionUID = 5441506605408584791L;
    protected boolean m_OutputClassname;
    protected boolean m_LinkGlobalActors;
    protected StringBuilder m_OutputBuffer;
    protected int m_Counter;
    protected Hashtable<String, String> m_NameIDRelation;

    @Override
    public String globalInfo() {
        return "Outputs the flow structure in DOT (GraphViz) format.\n\nFor more information on the DOT format, see:\nhttp://www.graphviz.org/content/dot-language";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UsePropertyNames = true;
        this.m_OutputClassname = false;
        this.m_LinkGlobalActors = false;
        this.m_NameIDRelation = new Hashtable();
    }

    @Override
    protected String initOutput() {
        return "";
    }

    @Override
    public String outputVariableValuesTipText() {
        return "This option is ignored, since only the structure is output.";
    }

    public void setOutputClassname(boolean value) {
        this.m_OutputClassname = value;
    }

    public boolean getOutputClassname() {
        return this.m_OutputClassname;
    }

    public String outputClassnameTipText() {
        return "Whether to output the classnames in the labels as well.";
    }

    public void setLinkGlobalActors(boolean value) {
        this.m_LinkGlobalActors = value;
    }

    public boolean getLinkGlobalActors() {
        return this.m_LinkGlobalActors;
    }

    public String linkGlobalActorsTipText() {
        return "Whether to output the links to global actors as well.";
    }

    @Override
    public String processOption(BooleanOption option) {
        return null;
    }

    protected String nextNodeID() {
        ++this.m_Counter;
        return "N" + this.m_Counter;
    }

    protected void addEdge(String from, String to) {
        this.m_OutputBuffer.append("  ");
        this.m_OutputBuffer.append(this.sanitize(from) + " -> " + this.sanitize(to));
        this.m_OutputBuffer.append("\n");
    }

    protected String sanitize(String label) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (i == 0) {
                if (c >= 'a' && c <= 'z') {
                    result.append(c);
                    continue;
                }
                if (c >= 'A' && c <= 'Z') {
                    result.append(c);
                    continue;
                }
                result.append("_");
                continue;
            }
            if (c >= '0' && c <= '9') {
                result.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                result.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                result.append(c);
                continue;
            }
            result.append("_");
        }
        return result.toString();
    }

    protected void addNode(String id, String label) {
        this.addNode(id, label, null, null);
    }

    protected void addNode(String id, String label, String shape, String style) {
        this.m_OutputBuffer.append("  ");
        this.m_OutputBuffer.append(this.sanitize(id));
        Vector<String> attrs = new Vector<String>();
        if (label != null) {
            attrs.add("label=\"" + Utils.backQuoteChars(label) + "\"");
        }
        if (shape != null) {
            attrs.add("shape=" + shape);
        }
        if (style != null) {
            attrs.add("style=\"" + style + "\"");
        }
        if (attrs.size() > 0) {
            this.m_OutputBuffer.append(" [");
            for (int i = 0; i < attrs.size(); ++i) {
                if (i > 0) {
                    this.m_OutputBuffer.append(" ");
                }
                this.m_OutputBuffer.append((String)attrs.get(i));
            }
            this.m_OutputBuffer.append("]");
        }
        this.m_OutputBuffer.append("\n");
    }

    protected String addNode(AbstractActor actor) {
        String shape = "box";
        String style = null;
        if (ActorUtils.isSource(actor)) {
            shape = "parallelogram";
        }
        if (actor instanceof Flow) {
            shape = "ellipse";
        }
        if (actor instanceof AbstractTee) {
            shape = "triangle";
        }
        if (actor instanceof Trigger) {
            shape = "ellipse";
        }
        if (actor instanceof Branch) {
            shape = "triangle";
        }
        if (actor instanceof IfThenElse) {
            shape = "diamond";
        }
        return this.addNode(actor, shape, style);
    }

    protected String addNode(AbstractActor actor, String shape, String style) {
        String result = this.nextNodeID();
        if (this.m_Nesting.size() > 0) {
            this.addEdge((String)this.m_Nesting.peek(), result);
        }
        String label = actor.getName();
        if (this.m_OutputClassname) {
            label = label + "\n[" + actor.getClass().getName().replaceFirst("^.*\\.flow\\.", "") + "]";
        }
        if (actor instanceof AbstractGlobalActor) {
            if (this.m_LinkGlobalActors) {
                String globalID;
                AbstractActor globalActor = ((AbstractGlobalActor)actor).getGlobalActor();
                if (globalActor != null && (globalID = this.m_NameIDRelation.get(globalActor.getFullName())) != null) {
                    this.addEdge(result, globalID);
                }
            } else {
                label = label + ": " + ((AbstractGlobalActor)actor).getGlobalName();
            }
        }
        this.addNode(result, label, shape, style);
        this.m_NameIDRelation.put(actor.getFullName(), result);
        return result;
    }

    protected String addVariableNode(String variable) {
        String result = this.nextNodeID();
        if (this.m_Nesting.size() > 0) {
            this.addEdge((String)this.m_Nesting.peek(), result);
        }
        this.addNode(result, variable, "box", "dotted");
        return result;
    }

    @Override
    public String processOption(ClassOption option) {
        if (!AbstractActor.class.isAssignableFrom(option.getBaseClass())) {
            return null;
        }
        if (option.isVariableAttached()) {
            this.addVariableNode(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            Object currValues = null;
            if (currValue != null) {
                if (!option.isMultiple()) {
                    Object value = currValue;
                    AbstractActor actor = (AbstractActor)value;
                    ActorHandler parent = (ActorHandler)((Object)actor.getParent());
                    ActorHandlerInfo info = parent.getActorHandlerInfo();
                    String id = this.addNode(actor);
                    this.m_Nesting.push(id);
                    this.doProduce(((OptionHandler)value).getOptionManager());
                } else {
                    currValues = currValue;
                    ActorHandlerInfo info = null;
                    int size = this.m_Nesting.size();
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Object value = Array.get(currValues, i);
                        AbstractActor actor = (AbstractActor)value;
                        ActorHandler parent = (ActorHandler)((Object)actor.getParent());
                        info = parent.getActorHandlerInfo();
                        String id = this.addNode(actor);
                        int sizeNested = this.m_Nesting.size();
                        this.m_Nesting.push(id);
                        this.doProduce(((OptionHandler)value).getOptionManager());
                        if (info.getActorExecution() == ActorExecution.SEQUENTIAL) continue;
                        while (this.m_Nesting.size() > sizeNested) {
                            this.m_Nesting.pop();
                        }
                    }
                    while (this.m_Nesting.size() > size) {
                        this.m_Nesting.pop();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String processOption(AbstractArgumentOption option) {
        return null;
    }

    @Override
    protected OptionHandler checkInput(OptionHandler object) {
        OptionHandler result = super.checkInput(object);
        if (!(result instanceof AbstractActor)) {
            throw new IllegalArgumentException("Input object must be derived from " + AbstractActor.class.getName());
        }
        return result;
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_Counter = 0;
        this.m_Output = null;
        this.m_OutputBuffer = new StringBuilder();
        this.m_OutputBuffer.append("digraph " + this.sanitize(this.getInput().getClass().getName()) + " {\n");
        AbstractActor actor = (AbstractActor)this.getInput();
        actor.setUp();
        String id = this.addNode(actor);
        this.m_Nesting.push(id);
    }

    @Override
    protected void postProduce() {
        super.postProduce();
        this.m_OutputBuffer.append("}\n");
        AbstractActor actor = (AbstractActor)this.getInput();
        actor.wrapUp();
        actor.cleanUp();
    }

    @Override
    public String getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.m_OutputBuffer.toString();
        }
        return (String)this.m_Output;
    }

    @Override
    public String toString() {
        return this.getOutput();
    }

    @Override
    public String getFileFormat() {
        return "GraphViz DOT format";
    }

    @Override
    public String getDefaultFileExtension() {
        return "dot";
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getDefaultFileExtension()};
    }
}

