/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.core.ConsoleObject;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.core.option.OptionUtils;
import adams.data.fit.Exp2;
import adams.data.fit.Fit;
import adams.data.fit.InitialParameterGuesser;
import adams.data.fit.NonlinearFunction;

@MixedCopyright
public class NonlinearLeastSquares
extends Fit
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 8031789267977329707L;
    protected NonlinearFunction m_Function;

    @Override
    public String globalInfo() {
        return "Performs Levenberg-Marquardt non-linear least squares curve fitting.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("function", "function", new Exp2());
    }

    @Override
    public String getDescription() {
        return "Non-linear least squares";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return new LevenbergMarquardt().getTechnicalInformation();
    }

    public void setFunction(NonlinearFunction value) {
        if (value != null) {
            this.m_Function = value;
        } else {
            this.getSystemErr().println("Function cannot be null!");
        }
    }

    public NonlinearFunction getFunction() {
        return this.m_Function;
    }

    public String functionTipText() {
        return "The function to use for calculating the y values based on the x input.";
    }

    @Override
    public boolean fit(double[] parameters, double[] x, double[] y, double[] sigma_x, double[] sigma_y) {
        int i;
        LevenbergMarquardt lm = new LevenbergMarquardt();
        double[] alamda = new double[1];
        double[] chisq = new double[1];
        int ma = parameters.length;
        int[] ia = new int[ma];
        double[] a = new double[ma];
        double[][] alpha = new double[ma][ma];
        double[][] covar = new double[ma][ma];
        for (i = 0; i < ma; ++i) {
            a[i] = parameters[i];
            ia[i] = 1;
        }
        alamda[0] = -1.0;
        while (alamda[0] < 1.0) {
            lm.mrqmin(x, y, sigma_y, x.length, a, ia, ma, covar, alpha, chisq, this.m_Function, alamda);
        }
        boolean result = alamda[0] < 1.0;
        alamda[0] = 0.0;
        lm.mrqmin(x, y, sigma_x, x.length, a, ia, ma, covar, alpha, chisq, this.m_Function, alamda);
        for (i = 0; i < ma; ++i) {
            parameters[i] = a[i];
        }
        return result;
    }

    @Override
    public double calculate(double[] parameters, double x) {
        return this.m_Function.calcY(x, parameters);
    }

    @Override
    public boolean canGuess() {
        return this.m_Function instanceof InitialParameterGuesser;
    }

    @Override
    public double[] guess(double[] x, double[] y) {
        if (this.canGuess()) {
            return ((InitialParameterGuesser)((Object)this.m_Function)).guess(x, y);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getDescription() + ": " + OptionUtils.getCommandLine(this.m_Function);
    }

    public static class LevenbergMarquardt
    extends ConsoleObject
    implements TechnicalInformationHandler {
        private static final long serialVersionUID = 1153571818457692622L;
        protected int mfit;
        protected double[] da;
        protected double[] ochisq;
        protected double[] atry;
        protected double[] beta;
        protected double[][] oneda;

        @Override
        public TechnicalInformation getTechnicalInformation() {
            TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INBOOK);
            result.setValue(TechnicalInformation.Field.AUTHOR, "William H. Press and Saul A. Teukolsky and William T. Vetterling and Brian P. Flannery");
            result.setValue(TechnicalInformation.Field.SERIES, "Numerical Recipes in C");
            result.setValue(TechnicalInformation.Field.EDITION, "Second");
            result.setValue(TechnicalInformation.Field.TITLE, "Nonlinear Models");
            result.setValue(TechnicalInformation.Field.CHAPTER, "15.5");
            result.setValue(TechnicalInformation.Field.PAGES, "681-688");
            result.setValue(TechnicalInformation.Field.YEAR, "1992");
            result.setValue(TechnicalInformation.Field.PUBLISHER, "Cambridge University Press");
            result.setValue(TechnicalInformation.Field.PDF, "http://www.nrbook.com/a/bookcpdf/c15-4.pdf");
            TechnicalInformation additional = result.add(TechnicalInformation.Type.MISC);
            additional.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
            additional.setValue(TechnicalInformation.Field.TITLE, "Non-linear least squares");
            additional.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Non-linear_least_squares");
            additional = result.add(TechnicalInformation.Type.MISC);
            additional.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
            additional.setValue(TechnicalInformation.Field.TITLE, "Singular value decomposition");
            additional.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Singular_value_decomposition");
            return result;
        }

        public void gaussj(double[][] a, int n, double[][] b, int m) {
            double tmp;
            int l;
            int k;
            int j;
            int icol = 0;
            int irow = 0;
            int[] indxc = new int[n];
            int[] indxr = new int[n];
            int[] ipiv = new int[n];
            for (j = 0; j < n; ++j) {
                ipiv[j] = 0;
            }
            for (int i = 0; i < n; ++i) {
                double big = 0.0;
                for (j = 0; j < n; ++j) {
                    if (ipiv[j] == 1) continue;
                    for (k = 0; k < n; ++k) {
                        if (ipiv[k] != 0 || !(Math.abs(a[j][k]) >= big)) continue;
                        big = Math.abs(a[j][k]);
                        irow = j;
                        icol = k;
                    }
                }
                int n2 = icol;
                ipiv[n2] = ipiv[n2] + 1;
                if (irow != icol) {
                    for (l = 0; l < n; ++l) {
                        tmp = a[irow][l];
                        a[irow][l] = a[icol][l];
                        a[icol][l] = tmp;
                    }
                    for (l = 0; l < m; ++l) {
                        tmp = b[irow][l];
                        b[irow][l] = b[icol][l];
                        b[icol][l] = tmp;
                    }
                }
                indxr[i] = irow;
                indxc[i] = icol;
                if (a[icol][icol] == 0.0) {
                    this.getSystemErr().println("gaussj: Singular Matrix");
                    return;
                }
                double pivinv = 1.0 / a[icol][icol];
                a[icol][icol] = 1.0;
                l = 0;
                while (l < n) {
                    double[] dArray = a[icol];
                    int n3 = l++;
                    dArray[n3] = dArray[n3] * pivinv;
                }
                l = 0;
                while (l < m) {
                    double[] dArray = b[icol];
                    int n4 = l++;
                    dArray[n4] = dArray[n4] * pivinv;
                }
                for (int ll = 0; ll < n; ++ll) {
                    if (ll == icol) continue;
                    double dum = a[ll][icol];
                    a[ll][icol] = 0.0;
                    for (l = 0; l < n; ++l) {
                        double[] dArray = a[ll];
                        int n5 = l;
                        dArray[n5] = dArray[n5] - a[icol][l] * dum;
                    }
                    for (l = 0; l < m; ++l) {
                        double[] dArray = b[ll];
                        int n6 = l;
                        dArray[n6] = dArray[n6] - b[icol][l] * dum;
                    }
                }
            }
            for (l = n - 1; l >= 0; --l) {
                if (indxr[l] == indxc[l]) continue;
                for (k = 0; k < n; ++k) {
                    tmp = a[k][indxr[l]];
                    a[k][indxr[l]] = a[k][indxc[l]];
                    a[k][indxc[l]] = tmp;
                }
            }
        }

        public void covsrt(double[][] covar, int ma, int[] ia, int mfit) {
            int j;
            int i;
            for (i = mfit; i < ma; ++i) {
                for (j = 0; j < i; ++j) {
                    covar[i][j] = 0.0;
                    covar[j][i] = 0.0;
                }
            }
            int k = mfit - 1;
            for (j = ma - 1; j >= 0; --j) {
                double swap;
                if (ia[j] != 1) continue;
                for (i = 0; i < ma; ++i) {
                    swap = covar[i][k];
                    covar[i][k] = covar[i][j];
                    covar[i][j] = swap;
                }
                for (i = 0; i < ma; ++i) {
                    swap = covar[k][i];
                    covar[k][i] = covar[j][i];
                    covar[j][i] = swap;
                }
                --k;
            }
        }

        public void mrqcof(double[] x, double[] y, double[] sig, int ndata, double[] a, int[] ia, int ma, double[][] alpha, double[] beta, double[] chisq, NonlinearFunction function) {
            int k;
            int j;
            int mfit = 0;
            double[] dyda = new double[ma];
            for (j = 0; j < ma; ++j) {
                if (ia[j] != 1) continue;
                ++mfit;
            }
            for (j = 0; j < mfit; ++j) {
                for (k = 0; k <= j; ++k) {
                    alpha[j][k] = 0.0;
                }
                beta[j] = 0.0;
            }
            chisq[0] = 0.0;
            for (int i = 0; i < ndata; ++i) {
                dyda = function.calcDerivatives(x[i], a);
                double ymod = function.calcY(x[i], a);
                double sig2i = sig != null && sig[i] != 0.0 ? 1.0 / (sig[i] * sig[i]) : 1.0;
                double dy = y[i] - ymod;
                j = -1;
                for (int l = 0; l < ma; ++l) {
                    if (ia[l] != 1) continue;
                    double wt = dyda[l] * sig2i;
                    ++j;
                    k = -1;
                    for (int m = 0; m <= l; ++m) {
                        if (ia[m] != 1) continue;
                        double[] dArray = alpha[j];
                        int n = ++k;
                        dArray[n] = dArray[n] + wt * dyda[m];
                    }
                    int n = j;
                    beta[n] = beta[n] + dy * wt;
                }
                chisq[0] = chisq[0] + dy * dy * sig2i;
            }
            for (j = 1; j < mfit; ++j) {
                for (k = 0; k < j; ++k) {
                    alpha[k][j] = alpha[j][k];
                }
            }
        }

        public void mrqmin(double[] x, double[] y, double[] sig, int ndata, double[] a, int[] ia, int ma, double[][] covar, double[][] alpha, double[] chisq, NonlinearFunction function, double[] alamda) {
            int l;
            int k;
            int j;
            if (alamda[0] < 0.0) {
                this.atry = new double[ma];
                this.beta = new double[ma];
                this.da = new double[ma];
                this.mfit = 0;
                for (j = 0; j < ma; ++j) {
                    if (ia[j] != 1) continue;
                    ++this.mfit;
                }
                this.oneda = new double[this.mfit][1];
                alamda[0] = 0.001;
                this.mrqcof(x, y, sig, ndata, a, ia, ma, alpha, this.beta, chisq, function);
                this.ochisq = new double[1];
                this.ochisq[0] = chisq[0];
                for (j = 0; j < ma; ++j) {
                    this.atry[j] = a[j];
                }
            }
            for (j = 0; j < this.mfit; ++j) {
                for (k = 0; k < this.mfit; ++k) {
                    covar[j][k] = alpha[j][k];
                }
                covar[j][j] = alpha[j][j] * (1.0 + alamda[0]);
                this.oneda[j][0] = this.beta[j];
            }
            this.gaussj(covar, this.mfit, this.oneda, 1);
            for (j = 0; j < this.mfit; ++j) {
                this.da[j] = this.oneda[j][0];
            }
            if (alamda[0] == 0.0) {
                this.covsrt(covar, ma, ia, this.mfit);
                this.covsrt(alpha, ma, ia, this.mfit);
                return;
            }
            j = -1;
            for (l = 0; l < ma; ++l) {
                if (ia[l] != 1) continue;
                this.atry[l] = a[l] + this.da[++j];
            }
            this.mrqcof(x, y, sig, ndata, this.atry, ia, ma, covar, this.da, chisq, function);
            if (chisq[0] < this.ochisq[0]) {
                alamda[0] = alamda[0] * 0.1;
                this.ochisq[0] = chisq[0];
                for (j = 0; j < this.mfit; ++j) {
                    for (k = 0; k < this.mfit; ++k) {
                        alpha[j][k] = covar[j][k];
                    }
                    this.beta[j] = this.da[j];
                }
                for (l = 0; l < ma; ++l) {
                    a[l] = this.atry[l];
                }
            } else {
                alamda[0] = alamda[0] * 10.0;
                chisq[0] = this.ochisq[0];
            }
        }
    }
}

